"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants"),sequelize_1=require("sequelize"),error_1=require("@b/utils/error");exports.metadata={summary:"Lists Staking Positions with computed rewards and earning details",operationId:"listStakingPositions",tags:["Staking","Admin","Positions"],parameters:[...constants_1.crudParameters,{index:constants_1.crudParameters.length,name:"poolId",in:"query",required:!1,schema:{type:"string"},description:"Filter positions by pool ID"},{index:constants_1.crudParameters.length+1,name:"status",in:"query",required:!1,schema:{type:"string",enum:["ACTIVE","COMPLETED","CANCELLED","PENDING_WITHDRAWAL"]},description:"Filter positions by status"}],responses:{401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Staking Positions"),500:query_1.serverErrorResponse},requiresAuth:!0,logModule:"ADMIN_STAKE",logTitle:"Get Staking Positions",permission:"view.staking.position",demoMask:["items.user.email"]};exports.default=async e=>{const{user:s,query:t,ctx:r}=e;null==r||r.step("Fetching data");if(!s)throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.success("Operation completed successfully");return(0,query_1.getFiltered)({model:db_1.models.stakingPosition,query:t,sortField:t.sortField||"createdAt",includeModels:[{model:db_1.models.user,as:"user",attributes:["id","email","firstName","lastName","avatar"]},{model:db_1.models.stakingPool,as:"pool",attributes:["id","name","symbol","apr"]},{model:db_1.models.stakingEarningRecord,as:"earningHistory",required:!1}],compute:[[(0,sequelize_1.literal)("(\n          SELECT COALESCE(SUM(ser.amount), 0)\n          FROM staking_earning_records AS ser\n          WHERE ser.positionId = stakingPosition.id\n            AND ser.isClaimed = false\n        )"),"pendingRewards"],[(0,sequelize_1.literal)("(\n          SELECT COALESCE(SUM(ser.amount), 0)\n          FROM staking_earning_records AS ser\n          WHERE ser.positionId = stakingPosition.id\n        )"),"earningsToDate"],[(0,sequelize_1.literal)("(\n          SELECT MAX(ser.createdAt)\n          FROM staking_earning_records AS ser\n          WHERE ser.positionId = stakingPosition.id\n        )"),"lastEarningDate"]]})};