"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),wallet_1=require("@b/services/wallet");exports.metadata={summary:"Bulk update staking positions",operationId:"bulkUpdateStakingPositions",tags:["Admin","Staking","Position","Bulk"],logModule:"ADMIN_STAKE",logTitle:"Bulk Update Positions",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",required:["positionIds","action"],properties:{positionIds:{type:"array",description:"Array of position IDs to update",items:{type:"string",format:"uuid"}},action:{type:"string",enum:["PAUSE","RESUME","COMPLETE","CANCEL"],description:"Action to perform on positions"},reason:{type:"string",description:"Optional reason for the action"}}}}}},responses:{200:{description:"Positions updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},updated:{type:"integer"},failed:{type:"integer"},errors:{type:"array",items:{type:"object",properties:{positionId:{type:"string"},error:{type:"string"}}}}}}}}},400:{description:"Invalid request data"},401:{description:"Unauthorized"},403:{description:"Forbidden - Admin access required"},500:{description:"Internal Server Error"}},requiresAuth:!0,permission:"access.staking.management"};exports.default=async e=>{const{user:t,body:o,ctx:i}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{positionIds:s,action:r,reason:a}=o;if(!Array.isArray(s)||0===s.length)throw(0,error_1.createError)({statusCode:400,message:"positionIds must be a non-empty array"});if(s.length>100)throw(0,error_1.createError)({statusCode:400,message:"Maximum 100 positions can be updated at once"});const n=["PAUSE","RESUME","COMPLETE","CANCEL"];if(!n.includes(r))throw(0,error_1.createError)({statusCode:400,message:`Invalid action. Must be one of: ${n.join(", ")}`});for(const e of s)if(!e||"string"!=typeof e)throw(0,error_1.createError)({statusCode:400,message:"All position IDs must be valid strings"});const d=await db_1.sequelize.transaction();let l=0;const p=[];try{null==i||i.step("Fetch all positions");const e=await db_1.models.stakingPosition.findAll({where:{id:{[sequelize_1.Op.in]:s}},include:[{model:db_1.models.stakingPool,as:"pool",attributes:["id","symbol","walletType","walletChain"]}],transaction:d});if(0===e.length)throw(0,error_1.createError)({statusCode:404,message:"No positions found with the provided IDs"});null==i||i.step("Process each position");for(const t of e)try{const e=t.status;let o=e,i=!1;switch(r){case"PAUSE":if("ACTIVE"===e){o="PAUSED";i=!0}else p.push({positionId:t.id,error:`Cannot pause position with status ${e}`});break;case"RESUME":if("PAUSED"===e){o="ACTIVE";i=!0}else p.push({positionId:t.id,error:`Cannot resume position with status ${e}`});break;case"COMPLETE":if(["ACTIVE","PAUSED"].includes(e)){o="COMPLETED";i=!0;const e=await db_1.models.wallet.findOne({where:{userId:t.userId,currency:t.pool.symbol,type:t.pool.walletType||"SPOT"},transaction:d});if(e){const o=`staking_complete_${t.id}`;await wallet_1.walletService.credit({idempotencyKey:o,userId:t.userId,walletId:e.id,walletType:t.pool.walletType||"SPOT",currency:t.pool.symbol,amount:t.amount,operationType:"STAKING_WITHDRAW",description:`Staking position ${t.id} completed - principal returned`,metadata:{source:"STAKING_COMPLETE",positionId:t.id,reason:a||"Admin action"},transaction:d})}}else p.push({positionId:t.id,error:`Cannot complete position with status ${e}`});break;case"CANCEL":if(["COMPLETED","CANCELLED"].includes(e))p.push({positionId:t.id,error:`Cannot cancel position with status ${e}`});else{o="CANCELLED";i=!0;const e=await db_1.models.wallet.findOne({where:{userId:t.userId,currency:t.pool.symbol,type:t.pool.walletType||"SPOT"},transaction:d});if(e){const o=`staking_cancel_${t.id}`;await wallet_1.walletService.credit({idempotencyKey:o,userId:t.userId,walletId:e.id,walletType:t.pool.walletType||"SPOT",currency:t.pool.symbol,amount:t.amount,operationType:"STAKING_WITHDRAW",description:`Staking position ${t.id} cancelled - principal returned`,metadata:{source:"STAKING_CANCEL",positionId:t.id,reason:a||"Admin action"},transaction:d})}}}if(i){await t.update({status:o,...["COMPLETED","CANCELLED"].includes(o)&&{completedAt:new Date}},{transaction:d});l++}}catch(e){p.push({positionId:t.id,error:e.message||"Failed to update position"})}null==i||i.step("Create admin activity log");await db_1.models.stakingAdminActivity.create({userId:t.id,action:"bulk_update",type:"positions",relatedId:null,metadata:{action:r,positionCount:s.length,updated:l,failed:p.length,reason:a||null,positionIds:s}},{transaction:d});await d.commit();null==i||i.success("Bulk position update completed successfully");return{message:"Bulk position update completed",updated:l,failed:p.length,errors:p.length>0?p:void 0}}catch(e){await d.rollback();if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to bulk update positions"})}};