"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Reorder staking pools display order",operationId:"reorderStakingPools",tags:["Admin","Staking","Pool","Reorder"],logModule:"ADMIN_STAKE",logTitle:"Reorder Pools Display Order",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",required:["poolOrders"],properties:{poolOrders:{type:"array",description:"Array of pool IDs in desired order",items:{type:"object",required:["poolId","order"],properties:{poolId:{type:"string",format:"uuid"},order:{type:"integer",minimum:0}}}}}}}}},responses:{200:{description:"Pools reordered successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},updated:{type:"integer"}}}}}},400:{description:"Invalid request data"},401:{description:"Unauthorized"},403:{description:"Forbidden - Admin access required"},500:{description:"Internal Server Error"}},requiresAuth:!0,permission:"access.staking.management"};exports.default=async e=>{const{user:r,body:o,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{poolOrders:s}=o;if(!Array.isArray(s)||0===s.length)throw(0,error_1.createError)({statusCode:400,message:"poolOrders must be a non-empty array"});const a=new Set,d=new Set;for(const e of s){if(!e.poolId||"string"!=typeof e.poolId)throw(0,error_1.createError)({statusCode:400,message:"Each entry must have a valid poolId"});if("number"!=typeof e.order||e.order<0||!Number.isInteger(e.order))throw(0,error_1.createError)({statusCode:400,message:"Each entry must have a valid non-negative integer order"});if(a.has(e.poolId))throw(0,error_1.createError)({statusCode:400,message:`Duplicate poolId found: ${e.poolId}`});a.add(e.poolId);if(d.has(e.order))throw(0,error_1.createError)({statusCode:400,message:`Duplicate order value found: ${e.order}`});d.add(e.order)}const i=await db_1.sequelize.transaction();try{null==t||t.step("Verify all pools exist");const e=await db_1.models.stakingPool.findAll({where:{id:Array.from(a)},attributes:["id"],transaction:i});if(e.length!==a.size){const r=new Set(e.map(e=>e.id)),o=Array.from(a).filter(e=>!r.has(e));throw(0,error_1.createError)({statusCode:400,message:`Pool(s) not found: ${o.join(", ")}`})}null==t||t.step("Update pool orders");const o=s.map(({poolId:e,order:r})=>db_1.models.stakingPool.update({displayOrder:r},{where:{id:e},transaction:i}));await Promise.all(o);null==t||t.step("Create admin activity log");await db_1.models.stakingAdminActivity.create({userId:r.id,action:"reorder",type:"pools",relatedId:null,metadata:{poolCount:s.length,poolOrders:s}},{transaction:i});await i.commit();null==t||t.success("Staking pools reordered successfully");return{message:"Staking pools reordered successfully",updated:s.length}}catch(e){await i.rollback();if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to reorder pools"})}};