"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),notifications_1=require("@b/utils/notifications");exports.metadata={summary:"Reorder Staking Pools",description:"Updates the order of staking pools based on the provided pool IDs array.",operationId:"reorderStakingPools",tags:["Staking","Admin","Pools"],requiresAuth:!0,logModule:"ADMIN_STAKE",logTitle:"Reorder Staking Pools",requestBody:{description:"Pool IDs in the desired order",required:!0,content:{"application/json":{schema:{type:"object",properties:{poolIds:{type:"array",items:{type:"string"}}},required:["poolIds"]}}}},responses:{200:{description:"Pools reordered successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"}}}}}},400:{description:"Bad Request"},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}},permission:"edit.staking.pool"};exports.default=async e=>{const{user:o,body:r,ctx:s}=e;if(!(null==o?void 0:o.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});if(!(null==r?void 0:r.poolIds)||!Array.isArray(r.poolIds)||0===r.poolIds.length)throw(0,error_1.createError)({statusCode:400,message:"Pool IDs array is required and must not be empty"});const{poolIds:t}=r;try{null==s||s.step("Reorder pools");await db_1.sequelize.transaction(async e=>{for(let o=0;o<t.length;o++)await db_1.models.stakingPool.update({order:o+1},{where:{id:t[o]},transaction:e})});try{await(0,notifications_1.createNotification)({userId:o.id,type:"system",title:"Staking Pools Reordered",message:"Staking pools have been reordered successfully.",details:"The new order is now reflected in the admin dashboard.",link:"/admin/staking/pools",actions:[{label:"View Pools",link:"/admin/staking/pools",primary:!0}]},s)}catch(e){console.error("Failed to create notification for pool reordering",e)}null==s||s.success("Pools reordered successfully");return{message:"Pools reordered successfully"}}catch(e){console.error("Error reordering staking pools:",e);throw(0,error_1.createError)({statusCode:500,message:e.message})}};