"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Aggregated Earnings",description:"Retrieves aggregated earnings data including overall totals, per-pool breakdown, and a detailed history of admin earnings with computed user earnings and position counts.",operationId:"getAggregatedEarnings",tags:["Staking","Admin","Earnings"],requiresAuth:!0,logModule:"ADMIN_STAKE",logTitle:"Get Staking Earnings",parameters:[{index:0,name:"poolId",in:"query",required:!1,schema:{type:"string"},description:"Filter earnings by pool ID"},{index:1,name:"startDate",in:"query",required:!1,schema:{type:"string",format:"date"},description:"Filter earnings by start date"},{index:2,name:"endDate",in:"query",required:!1,schema:{type:"string",format:"date"},description:"Filter earnings by end date"}],responses:{200:{description:"Aggregated earnings retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{totals:{type:"object",properties:{totalUserEarnings:{type:"number"},totalAdminEarnings:{type:"number"},totalEarnings:{type:"number"}}},earningsByPool:{type:"array",items:{type:"object",properties:{poolId:{type:"string"},poolName:{type:"string"},totalUserEarnings:{type:"number"},totalAdminEarnings:{type:"number"},totalEarnings:{type:"number"}}}},history:{type:"array",items:{type:"object"}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}},permission:"view.staking.earning"};exports.default=async e=>{const{user:t,query:n,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==r||r.step("Fetching data");const e={},t={};(null==n?void 0:n.poolId)&&(e.poolId=n.poolId);if(null==n?void 0:n.startDate){const r=new Date(n.startDate);e.createdAt={...e.createdAt||{},[sequelize_1.Op.gte]:r};t.createdAt={...t.createdAt||{},[sequelize_1.Op.gte]:r}}if(null==n?void 0:n.endDate){const r=new Date(n.endDate);e.createdAt={...e.createdAt||{},[sequelize_1.Op.lte]:r};t.createdAt={...t.createdAt||{},[sequelize_1.Op.lte]:r}}const o=await db_1.models.stakingAdminEarning.findAll({where:e,raw:!0}),a={};let i=0;for(const e of o){const t=e.poolId;a[t]=(a[t]||0)+e.amount;i+=e.amount}const s=await db_1.models.stakingEarningRecord.findAll({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("stakingEarningRecord.amount")),"totalUserEarnings"],[(0,sequelize_1.col)("position.poolId"),"poolId"]],include:[{model:db_1.models.stakingPosition,as:"position",attributes:[],where:(null==n?void 0:n.poolId)?{poolId:n.poolId}:void 0}],where:t,group:["position.poolId"],raw:!0}),d={};let l=0;for(const e of s){const t=e.poolId,n=parseFloat(e.totalUserEarnings)||0;d[t]=n;l+=n}const g=i+l,u=new Set([...Object.keys(a),...Object.keys(d)]),p=[];for(const e of u){const t=await db_1.models.stakingPool.findByPk(e,{raw:!0});p.push({poolId:e,poolName:t?t.name:"Unknown",totalUserEarnings:d[e]||0,totalAdminEarnings:a[e]||0,totalEarnings:(d[e]||0)+(a[e]||0)})}const c=await Promise.all(o.map(async e=>{const t=new Date(e.createdAt),n=new Date(t.getTime()+864e5),r=await db_1.models.stakingEarningRecord.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("stakingEarningRecord.amount")),"userEarnings"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.fn)("DISTINCT",(0,sequelize_1.col)("position.id"))),"numberOfPositions"]],include:[{model:db_1.models.stakingPosition,as:"position",attributes:[],where:{poolId:e.poolId}}],where:{createdAt:{[sequelize_1.Op.gte]:t,[sequelize_1.Op.lt]:n}},raw:!0}),o=parseFloat(null==r?void 0:r.userEarnings)||0,a=parseInt(null==r?void 0:r.numberOfPositions)||0;return{id:e.id,poolId:e.poolId,createdAt:e.createdAt,adminEarnings:e.amount,userEarnings:o,numberOfPositions:a}}));null==r||r.success("Staking earnings retrieved successfully");return{totals:{totalUserEarnings:l,totalAdminEarnings:i,totalEarnings:g},earningsByPool:p,history:c}}catch(e){console.error("Error fetching aggregated earnings:",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch aggregated earnings"})}};