"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console");exports.metadata={summary:"Create Global P2P Payment Method",description:"Creates a new global payment method that is available to all users. Admin only.",operationId:"createGlobalP2PPaymentMethod",tags:["Admin","P2P","Payment Method"],requiresAuth:!0,permission:"create.p2p.payment_method",logModule:"ADMIN_P2P",logTitle:"Create global payment method",requestBody:{description:"Global payment method data",required:!0,content:{"application/json":{schema:{type:"object",properties:{name:{type:"string",description:"Payment method name"},icon:{type:"string",description:"Icon URL or icon class"},description:{type:"string",description:"Payment method description"},instructions:{type:"string",description:"Instructions for using this payment method"},metadata:{type:"object",description:"Flexible key-value pairs for payment details"},processingTime:{type:"string",description:"Expected processing time"},fees:{type:"string",description:"Fee information"},available:{type:"boolean",description:"Whether the payment method is currently available"},popularityRank:{type:"number",description:"Sorting rank (lower numbers appear first)"}},required:["name","icon"]}}}},responses:{200:{description:"Global payment method created successfully."},401:{description:"Unauthorized."},403:{description:"Forbidden - Admin access required."},400:{description:"Bad request - Invalid data."},500:{description:"Internal Server Error."}}};exports.default=async e=>{const{body:t,user:a,ctx:i}=e;if(!(null==a?void 0:a.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==i||i.step("Validating required fields");if(!t.name||!t.icon){null==i||i.fail("Missing required fields");throw(0,error_1.createError)({statusCode:400,message:"Name and icon are required fields"})}null==i||i.step("Checking for duplicate payment method");if(await db_1.models.p2pPaymentMethod.findOne({where:{name:t.name,isGlobal:!0,deletedAt:null}})){null==i||i.fail("Duplicate payment method name");throw(0,error_1.createError)({statusCode:400,message:"A global payment method with this name already exists"})}null==i||i.step("Sanitizing metadata");let e=null;if(t.metadata&&"object"==typeof t.metadata){e={};for(const[a,i]of Object.entries(t.metadata))"string"==typeof a&&a.trim()&&(e[a.trim()]=String(i));0===Object.keys(e).length&&(e=null)}null==i||i.step("Creating global payment method");const r=await db_1.models.p2pPaymentMethod.create({userId:null,name:t.name,icon:t.icon,description:t.description||null,instructions:t.instructions||null,metadata:e,processingTime:t.processingTime||null,fees:t.fees||null,available:!1!==t.available,isGlobal:!0,popularityRank:t.popularityRank||0});console_1.logger.info("P2P",`Created global payment method: ${r.id} - ${r.name} by admin ${a.id}`);null==i||i.step("Logging admin activity");await db_1.models.p2pActivityLog.create({userId:a.id,type:"ADMIN_PAYMENT_METHOD",action:"CREATED",relatedEntity:"PAYMENT_METHOD",relatedEntityId:r.id,details:JSON.stringify({name:t.name,icon:t.icon,isGlobal:!0,adminAction:!0,updatedBy:`${a.firstName} ${a.lastName}`,action:"created"})});null==i||i.success("Global payment method created successfully");return{message:"Global payment method created successfully.",paymentMethod:{id:r.id,userId:r.userId,name:r.name,icon:r.icon,description:r.description,instructions:r.instructions,metadata:r.metadata,processingTime:r.processingTime,fees:r.fees,available:r.available,isGlobal:r.isGlobal,popularityRank:r.popularityRank,createdAt:r.createdAt}}}catch(e){if(e.statusCode)throw e;null==i||i.fail("Failed to create global payment method");throw(0,error_1.createError)({statusCode:500,message:"Failed to create global payment method: "+e.message})}};