"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors"),utils_1=require("./utils");exports.metadata={summary:"List Mailwizard campaigns",operationId:"listMailwizardCampaigns",tags:["Admin","Mailwizard","Campaigns"],description:"Retrieves a paginated list of all Mailwizard campaigns with optional filtering and sorting. Includes associated template information for each campaign. Supports filtering by status, name, subject, and date ranges.",parameters:constants_1.crudParameters,responses:{200:(0,errors_1.paginatedResponse)({type:"object",properties:{...utils_1.mailwizardCampaignSchema,template:{type:"object",properties:{id:{type:"string",description:"Template ID"},name:{type:"string",description:"Template name"}}}}},"Mailwizard campaigns retrieved successfully"),401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Mailwizard Campaign"),500:errors_1.serverErrorResponse},requiresAuth:!0,logModule:"ADMIN_MAIL",logTitle:"Get Mail Campaigns",permission:"view.mailwizard.campaign"};exports.default=async e=>{const{query:a,ctx:s}=e;null==s||s.step("Process request");null==s||s.success("Get Mail Campaigns retrieved successfully");return(0,query_1.getFiltered)({model:db_1.models.mailwizardCampaign,query:a,sortField:a.sortField||"createdAt",customStatus:[{key:"status",true:"ACTIVE",false:"PENDING"}],includeModels:[{model:db_1.models.mailwizardTemplate,as:"template",attributes:["id","name"]}]})};