"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Create ICO Platform Settings",description:"Creates or updates ICO platform settings using upsert. This endpoint initializes platform-wide configuration for ICO operations.",operationId:"createIcoPlatformSettings",tags:["Admin","ICO","Settings"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{minInvestmentAmount:{type:"number",description:"Minimum investment amount"},maxInvestmentAmount:{type:"number",description:"Maximum investment amount"},platformFeePercentage:{type:"number",description:"Platform fee percentage"},kycRequired:{type:"boolean",description:"KYC requirement flag"},maintenanceMode:{type:"boolean",description:"Maintenance mode flag"},allowPublicOfferings:{type:"boolean",description:"Allow public offerings flag"},announcementMessage:{type:"string",description:"Announcement message"},announcementActive:{type:"boolean",description:"Announcement active flag"}},required:["minInvestmentAmount","maxInvestmentAmount","platformFeePercentage"]}}}},responses:{200:{description:"Platform settings created successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"edit.ico.settings",logModule:"ADMIN_ICO",logTitle:"Create platform settings"};exports.default=async e=>{const{user:t,body:n,ctx:o}=e;null==o||o.step("Validating user permissions");if(!(null==t?void 0:t.id)){null==o||o.fail("Unauthorized access");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{minInvestmentAmount:r,maxInvestmentAmount:s,platformFeePercentage:i,kycRequired:a,maintenanceMode:l,allowPublicOfferings:u,announcementMessage:c,announcementActive:m}=n;null==o||o.step("Preparing platform settings");const p=[{key:"icoPlatformMinInvestmentAmount",value:null==r?void 0:r.toString()},{key:"icoPlatformMaxInvestmentAmount",value:null==s?void 0:s.toString()},{key:"icoPlatformFeePercentage",value:null==i?void 0:i.toString()},{key:"icoPlatformKycRequired",value:null==a?void 0:a.toString()},{key:"icoPlatformMaintenanceMode",value:null==l?void 0:l.toString()},{key:"icoPlatformAllowPublicOfferings",value:null==u?void 0:u.toString()},{key:"icoPlatformAnnouncementMessage",value:c},{key:"icoPlatformAnnouncementActive",value:null==m?void 0:m.toString()}].filter(e=>void 0!==e.value);null==o||o.step(`Creating ${p.length} platform settings`);for(const e of p)await db_1.models.settings.upsert({key:e.key,value:e.value});null==o||o.success("Platform settings created successfully");return{message:"Platform settings created successfully."}};