"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get ICO Investment Limits",description:"Retrieves the current ICO investment limit settings including min/max investment amounts, soft cap percentage, vesting configuration, and refund grace period.",operationId:"getIcoInvestmentLimits",tags:["Admin","ICO","Settings"],requiresAuth:!0,requiresAdmin:!0,responses:{200:{description:"ICO limits retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{minInvestment:{type:"number",description:"Minimum investment amount"},maxInvestment:{type:"number",description:"Maximum investment amount"},maxPerUser:{type:"number",description:"Maximum investment per user"},softCapPercentage:{type:"number",description:"Soft cap percentage threshold"},refundGracePeriod:{type:"number",description:"Refund grace period in days"},vestingEnabled:{type:"boolean",description:"Whether token vesting is enabled"},defaultVestingMonths:{type:"number",description:"Default vesting period in months"}}}}}},401:errors_1.unauthorizedResponse,403:errors_1.forbiddenResponse,500:errors_1.serverErrorResponse},logModule:"ADMIN_ICO",logTitle:"Get ICO limits"};exports.default=async e=>{var t,r;const{user:i,ctx:n}=e;if(!(null==i?void 0:i.id)){null==n||n.fail("Authentication required");throw(0,error_1.createError)({statusCode:401,message:"Authentication required"})}null==n||n.step("Checking admin privileges");const s=await db_1.models.user.findByPk(i.id,{include:[{model:db_1.models.role,as:"role"}]});if(!s||"admin"!==(null===(t=s.role)||void 0===t?void 0:t.name)&&"super_admin"!==(null===(r=s.role)||void 0===r?void 0:r.name)){null==n||n.fail("Admin privileges required");throw(0,error_1.createError)({statusCode:403,message:"Admin privileges required"})}null==n||n.step("Fetching ICO limit settings");const o=(await db_1.models.settings.findAll({where:{key:["icoMinInvestment","icoMaxInvestment","icoMaxPerUser","icoSoftCapPercentage","icoRefundGracePeriod","icoVestingEnabled","icoDefaultVestingMonths"]}})).reduce((e,t)=>{e[t.key]=t.value;return e},{});null==n||n.success("ICO limits retrieved successfully");return{minInvestment:parseFloat(o.icoMinInvestment||"10"),maxInvestment:parseFloat(o.icoMaxInvestment||"100000"),maxPerUser:parseFloat(o.icoMaxPerUser||"50000"),softCapPercentage:parseFloat(o.icoSoftCapPercentage||"30"),refundGracePeriod:parseInt(o.icoRefundGracePeriod||"7"),vestingEnabled:"true"===o.icoVestingEnabled,defaultVestingMonths:parseInt(o.icoDefaultVestingMonths||"12")}};