"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"List ICO Launch Plans",description:"Retrieves all ICO launch plans ordered by sort order. Launch plans define pricing tiers and feature sets for token offering creators.",operationId:"getIcoLaunchPlans",tags:["Admin","ICO","Settings"],requiresAuth:!0,responses:{200:{description:"Launch plans retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",format:"uuid"},name:{type:"string",description:"Plan name"},description:{type:"string",description:"Plan description"},price:{type:"number",description:"Plan price"},currency:{type:"string",description:"Currency code (e.g., USD)"},walletType:{type:"string",description:"Wallet type for the plan"},features:{type:"object",description:"Plan features in JSON format"},recommended:{type:"boolean",description:"Whether this plan is recommended"},status:{type:"boolean",description:"Whether the plan is active"},sortOrder:{type:"number",description:"Sort order for display"},createdAt:{type:"string",format:"date-time"},updatedAt:{type:"string",format:"date-time"},deletedAt:{type:"string",format:"date-time",nullable:!0}}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"view.ico.settings",logModule:"ADMIN_ICO",logTitle:"Get launch plans"};exports.default=async e=>{const{user:r,ctx:t}=e;null==t||t.step("Validating user permissions");if(!(null==r?void 0:r.id)){null==t||t.fail("Unauthorized access");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}null==t||t.step("Fetching launch plans");const s=await db_1.models.icoLaunchPlan.findAll({order:[["sortOrder","ASC"]]});null==t||t.success(`Retrieved ${s.length} launch plans`);return s};