"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Create ICO Blockchain Configuration",description:"Creates a new blockchain configuration for ICO token offerings. The blockchain must have a unique name and value identifier.",operationId:"createIcoBlockchain",tags:["Admin","ICO","Settings"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{name:{type:"string",description:"The display name of the blockchain"},value:{type:"string",description:"The unique value identifier for the blockchain"},status:{type:"boolean",description:"Status flag. Defaults to true if not provided"}},required:["name","value"]}}}},responses:{200:{description:"Blockchain configuration created successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"edit.ico.settings",logModule:"ADMIN_ICO",logTitle:"Create blockchain configuration"};exports.default=async e=>{const{user:r,body:t,ctx:s}=e;null==s||s.step("Validating user permissions");if(!(null==r?void 0:r.id)){null==s||s.fail("Unauthorized access");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{name:i,value:o,status:a}=t;null==s||s.step("Validating blockchain data");if(!i||!o){null==s||s.fail("Missing required fields");throw(0,error_1.createError)({statusCode:400,message:"Missing required fields: name, value and description"})}const n=void 0===a||a;null==s||s.step("Creating blockchain configuration");await db_1.models.icoBlockchain.create({name:i,value:o,status:n});null==s||s.success("Blockchain configuration created successfully");return{message:"Blockchain configuration created successfully."}};