"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants");exports.metadata={summary:"List gateway refunds",description:"Retrieves a paginated list of all gateway refunds with filtering and sorting capabilities. Includes merchant and payment information for each refund.",operationId:"listGatewayRefunds",tags:["Admin","Gateway","Refund"],parameters:constants_1.crudParameters,responses:{200:{description:"Paginated list of refunds",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",description:"Refund with merchant and payment information"}},pagination:{type:"object",properties:{total:{type:"number"},page:{type:"number"},perPage:{type:"number"}}}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0,permission:"view.gateway.refund",demoMask:["items.merchant.email"],logModule:"ADMIN_GATEWAY",logTitle:"List gateway refunds"};exports.default=async e=>{var t;const{query:a,ctx:r}=e;null==r||r.step("Fetching refunds list");const n=await(0,query_1.getFiltered)({model:db_1.models.gatewayRefund,query:a,sortField:a.sortField||"createdAt",includeModels:[{model:db_1.models.gatewayMerchant,as:"merchant",attributes:["id","name","email"]},{model:db_1.models.gatewayPayment,as:"payment",attributes:["paymentIntentId","merchantOrderId","amount","currency"]}]});null==r||r.success(`Retrieved ${(null===(t=n.items)||void 0===t?void 0:t.length)||0} refunds`);return n};