"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants");exports.metadata={summary:"List gateway payouts",description:"Retrieves a paginated list of all gateway merchant payouts with filtering and sorting capabilities. Includes merchant information for each payout. Returns both active and deleted records (paranoid: false).",operationId:"listGatewayPayouts",tags:["Admin","Gateway","Payout"],parameters:constants_1.crudParameters,responses:{200:{description:"Paginated list of payouts",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",description:"Payout with merchant information"}},pagination:{type:"object",properties:{total:{type:"number"},page:{type:"number"},perPage:{type:"number"}}}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0,permission:"view.gateway.payout",demoMask:["items.merchant.email"],logModule:"ADMIN_GATEWAY",logTitle:"List gateway payouts"};exports.default=async e=>{var t;const{query:a,ctx:s}=e;null==s||s.step("Fetching payouts list");const r=await(0,query_1.getFiltered)({model:db_1.models.gatewayPayout,query:a,sortField:a.sortField||"createdAt",paranoid:!1,includeModels:[{model:db_1.models.gatewayMerchant,as:"merchant",attributes:["id","name","email"]}]});null==s||s.success(`Retrieved ${(null===(t=r.items)||void 0===t?void 0:t.length)||0} payouts`);return r};