"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const constants_1=require("@b/utils/constants"),errors_1=require("@b/utils/schema/errors"),utils_1=require("./utils");let getFiltered;try{const e=require("@b/api/(ext)/ecosystem/utils/scylla/query");getFiltered=e.getFiltered}catch(e){}exports.metadata={summary:"Lists all futures positions with pagination and filtering",operationId:"listFuturesPositions",tags:["Admin","Futures","Position"],description:"Retrieves a paginated list of all futures positions from ScyllaDB with support for filtering, sorting, and search. Returns position details including side, entry price, amount, leverage, unrealized PnL, stop loss, take profit, and associated user information.",parameters:constants_1.crudParameters,responses:{200:{description:"Futures positions retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",properties:utils_1.positionSchema}},pagination:constants_1.paginationSchema}}}}},401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Futures Positions"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"view.futures.position",logModule:"ADMIN_FUTURES",logTitle:"List futures positions"};const keyspace=process.env.SCYLLA_FUTURES_KEYSPACE||"futures";exports.default=async e=>{const{query:t,ctx:s}=e;if(!getFiltered)return{error:"Ecosystem extension not available",status:500};null==s||s.step("Fetching futures positions");const r=await getFiltered({table:"position",query:t,filter:t.filter,sortField:t.sortField||"createdAt",sortOrder:t.sortOrder||"DESC",perPage:Number(t.perPage)||10,allowFiltering:!0,keyspace:keyspace,partitionKeys:["userId"],transformColumns:["entryPrice","amount","leverage","unrealizedPnl","stopLossPrice","takeProfitPrice"],nonStringLikeColumns:["userId"]});null==s||s.success(`Retrieved ${r.items.length} futures positions`);return r};