"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),errors_1=require("@b/utils/schema/errors");let scyllaQuery;try{const e=require("@b/api/(ext)/ecosystem/utils/scylla/query");scyllaQuery=e}catch(e){}exports.metadata={summary:"Get futures dashboard analytics",operationId:"getFuturesDashboard",tags:["Admin","Futures","Dashboard"],description:"Retrieves comprehensive futures trading dashboard data including position statistics, market overview, volume metrics, and recent activity.",parameters:[{name:"timeRange",in:"query",description:"Time range for analytics (24h, 7d, 30d)",required:!1,schema:{type:"string",default:"7d"}}],responses:{200:{description:"Dashboard data retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{overview:{type:"object",properties:{totalMarkets:{type:"number"},activeMarkets:{type:"number"},totalPositions:{type:"number"},activePositions:{type:"number"},closedPositions:{type:"number"},liquidatedPositions:{type:"number"},totalVolume:{type:"number"},totalPnl:{type:"number"},longPositions:{type:"number"},shortPositions:{type:"number"}}},recentPositions:{type:"array",items:{type:"object"}},topMarkets:{type:"array",items:{type:"object"}},chartData:{type:"object"}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"access.futures.market",logModule:"ADMIN_FUTURES",logTitle:"Get Futures Dashboard"};const keyspace=process.env.SCYLLA_FUTURES_KEYSPACE||"futures";exports.default=async e=>{const{query:t,ctx:s}=e,a=t.timeRange||"7d";null==s||s.step("Fetching futures dashboard data");const r=new Date,o=new Date;switch(a){case"24h":o.setDate(r.getDate()-1);break;case"7d":default:o.setDate(r.getDate()-7);break;case"30d":o.setDate(r.getDate()-30)}const i=await db_1.models.futuresMarket.findAll({attributes:["id","currency","pair","status","isTrending","isHot","metadata"]}),n=i.length,l=i.filter(e=>!0===e.status).length;let c={total:0,active:0,closed:0,liquidated:0,cancelled:0,longPositions:0,shortPositions:0,totalPnl:0,totalVolume:0},u=[],d={labels:[],datasets:[]};if(null==scyllaQuery?void 0:scyllaQuery.getFiltered)try{const e=await scyllaQuery.getFiltered({table:"position",query:{},sortField:"createdAt",sortOrder:"DESC",perPage:1e3,allowFiltering:!0,keyspace:keyspace,partitionKeys:["userId"],transformColumns:["entryPrice","amount","leverage","unrealizedPnl"]}),t=(null==e?void 0:e.items)||[];c.total=t.length;t.forEach(e=>{var t,s;const a=(null===(t=e.status)||void 0===t?void 0:t.toUpperCase())||"";"OPEN"===a||"ACTIVE"===a?c.active++:"CLOSED"===a?c.closed++:"LIQUIDATED"===a?c.liquidated++:"CANCELLED"===a&&c.cancelled++;const r=(null===(s=e.side)||void 0===s?void 0:s.toUpperCase())||"";"BUY"===r||"LONG"===r?c.longPositions++:"SELL"!==r&&"SHORT"!==r||c.shortPositions++;const o=parseFloat(e.unrealizedPnl||"0");isNaN(o)||(c.totalPnl+=o);const i=parseFloat(e.amount||"0"),n=parseFloat(e.entryPrice||"0");isNaN(i)||isNaN(n)||(c.totalVolume+=i*n)});u=t.slice(0,10).map(e=>({id:e.id,symbol:e.symbol,side:e.side,status:e.status,entryPrice:parseFloat(e.entryPrice||"0"),amount:parseFloat(e.amount||"0"),leverage:parseFloat(e.leverage||"1"),unrealizedPnl:parseFloat(e.unrealizedPnl||"0"),createdAt:e.createdAt,userId:e.userId}));const s=[],r=[],o=[];for(let e=("24h"===a?24:"7d"===a?7:30)-1;e>=0;e--){const i=new Date;if("24h"===a){i.setHours(i.getHours()-e);s.push(i.toLocaleTimeString("en-US",{hour:"2-digit"}))}else{i.setDate(i.getDate()-e);s.push(i.toLocaleDateString("en-US",{month:"short",day:"numeric"}))}const n=t.filter(e=>{if(!e.createdAt)return!1;const t=new Date(e.createdAt);return"24h"===a?t.getHours()===i.getHours()&&t.getDate()===i.getDate():t.toDateString()===i.toDateString()});r.push(n.length);let l=0;n.forEach(e=>{const t=parseFloat(e.amount||"0"),s=parseFloat(e.entryPrice||"0");isNaN(t)||isNaN(s)||(l+=t*s)});o.push(l)}d={labels:s,datasets:[{label:"Positions",data:r,borderColor:"#f59e0b",backgroundColor:"rgba(245, 158, 11, 0.1)"},{label:"Volume",data:o,borderColor:"#ef4444",backgroundColor:"rgba(239, 68, 68, 0.1)"}]}}catch(e){console.error("Error fetching position data from ScyllaDB:",e)}const p=i.filter(e=>!0===e.status).slice(0,5).map(e=>({id:e.id,symbol:`${e.currency}/${e.pair}`,currency:e.currency,pair:e.pair,isTrending:e.isTrending,isHot:e.isHot,metadata:e.metadata}));null==s||s.success("Dashboard data retrieved successfully");return{overview:{totalMarkets:n,activeMarkets:l,totalPositions:c.total,activePositions:c.active,closedPositions:c.closed,liquidatedPositions:c.liquidated,cancelledPositions:c.cancelled,longPositions:c.longPositions,shortPositions:c.shortPositions,totalPnl:c.totalPnl,totalVolume:c.totalVolume},recentPositions:u,topMarkets:p,chartData:d,timeRange:a}};