"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk Update FAQs",description:"Updates multiple FAQ entries in a single operation. Applies the same update data to all specified FAQ IDs.",operationId:"bulkUpdateFaqs",tags:["Admin","FAQ","BulkOperations"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string",format:"uuid"},description:"Array of FAQ IDs to update"},data:{type:"object",description:"Fields to update on all FAQs"}},required:["ids","data"]}}}},responses:{200:(0,errors_1.successMessageResponse)("FAQs updated successfully"),400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"edit.faq",logModule:"ADMIN_FAQ",logTitle:"Bulk update FAQs"};exports.default=async e=>{const{user:s,body:r,ctx:t}=e;if(!(null==s?void 0:s.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{ids:o,data:a}=r;if(!Array.isArray(o)||0===o.length){null==t||t.fail("No FAQ IDs provided");throw(0,error_1.createError)({statusCode:400,message:"No FAQ IDs provided"})}null==t||t.step("Updating FAQs");await db_1.models.faq.update(a,{where:{id:o}});null==t||t.success("FAQs updated successfully");return{message:"FAQs updated successfully"}};