"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get FAQ Analytics Data",description:"Retrieves comprehensive analytics data for the FAQ system including total FAQs, views, feedback ratings, category distribution, top search queries, and time-series data for feedback and views.",operationId:"getFaqAnalytics",tags:["Admin","FAQ","Analytics"],requiresAuth:!0,responses:{200:{description:"Analytics data retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{totalFaqs:{type:"number",description:"Total number of FAQs"},activeFaqs:{type:"number",description:"Number of active FAQs"},totalViews:{type:"number",description:"Total FAQ views"},averageRating:{type:"number",description:"Average rating (0-1)"},positiveRatingPercentage:{type:"number"},negativeRatingPercentage:{type:"number"},viewsComparison:{type:"object",description:"Current vs previous month views comparison"},feedbackComparison:{type:"object",description:"Positive and negative feedback comparison"},mostViewedFaqs:{type:"array",description:"Top 5 most viewed FAQs",items:{type:"object"}},categoryDistribution:{type:"array",description:"FAQ count by category",items:{type:"object"}},topSearchQueries:{type:"array",description:"Top 10 search queries",items:{type:"object"}},feedbackOverTime:{type:"array",description:"Daily feedback counts",items:{type:"object"}},viewsOverTime:{type:"array",description:"Monthly views data",items:{type:"object"}}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"access.faq",logModule:"ADMIN_FAQ",logTitle:"Get FAQ analytics"};exports.default=async e=>{var t,i,a,s;const{user:r,ctx:o}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==o||o.step("Fetching FAQ analytics data");const e=(new Date).getFullYear(),r=new Date(`${e}-01-01`),n=new Date(`${e}-12-31`),l=await db_1.models.faq.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"totalFaqs"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status = true THEN 1 ELSE 0 END")),"activeFaqs"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("views")),"totalViews"]],raw:!0}),u=parseInt((null==l?void 0:l.totalFaqs)||"0",10),c=parseInt((null==l?void 0:l.activeFaqs)||"0",10),d=parseInt((null==l?void 0:l.totalViews)||"0",10),[p,v,q,f,g,_,m]=await Promise.all([db_1.models.faqFeedback.findAll({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN isHelpful THEN 1 ELSE 0 END")),"helpfulCount"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN NOT isHelpful THEN 1 ELSE 0 END")),"notHelpfulCount"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"totalFeedback"]],raw:!0}),db_1.models.faq.findAll({attributes:["id","question","views","category"],order:[["views","DESC"]],limit:5,raw:!0}),db_1.models.faq.findAll({attributes:["category",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"]],group:["category"],raw:!0}),db_1.models.faqSearch.findAll({attributes:["query",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("query")),"count"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("resultCount")),"averageResults"]],group:["query"],order:[[(0,sequelize_1.literal)("count"),"DESC"]],limit:10,raw:!0}),db_1.models.faqFeedback.findAll({attributes:[[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt")),"date"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN isHelpful THEN 1 ELSE 0 END")),"positive"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN NOT isHelpful THEN 1 ELSE 0 END")),"negative"]],group:[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt"))],order:[[(0,sequelize_1.literal)("date"),"ASC"]],raw:!0}),db_1.models.faq.findAll({attributes:[[(0,sequelize_1.fn)("DATE_FORMAT",(0,sequelize_1.col)("createdAt"),"%Y-%m-01"),"month"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("views")),"views"]],where:{createdAt:{[sequelize_1.Op.between]:[r,n]}},group:[(0,sequelize_1.fn)("DATE_FORMAT",(0,sequelize_1.col)("createdAt"),"%Y-%m-01")],order:[[(0,sequelize_1.literal)("month"),"ASC"]],raw:!0}),db_1.models.faqFeedback.findAll({attributes:[[(0,sequelize_1.fn)("DATE_FORMAT",(0,sequelize_1.col)("createdAt"),"%Y-%m-01"),"month"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN isHelpful THEN 1 ELSE 0 END")),"positive"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN NOT isHelpful THEN 1 ELSE 0 END")),"negative"]],where:{createdAt:{[sequelize_1.Op.between]:[r,n]}},group:[(0,sequelize_1.fn)("DATE_FORMAT",(0,sequelize_1.col)("createdAt"),"%Y-%m-01")],order:[[(0,sequelize_1.literal)("month"),"ASC"]],raw:!0})]),E=p[0]||{},b=parseInt(E.helpfulCount||"0",10),A=parseInt(E.notHelpfulCount||"0",10),y=parseInt(E.totalFeedback||"0",10),z=y?b/y:0,w=y?b/y*100:0,F=y?A/y*100:0,S=v.map(e=>e.id),h=(S.length?await db_1.models.faqFeedback.findAll({attributes:["faqId",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN isHelpful THEN 1 ELSE 0 END")),"positiveCount"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN NOT isHelpful THEN 1 ELSE 0 END")),"negativeCount"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"totalFeedback"]],where:{faqId:{[sequelize_1.Op.in]:S}},group:["faqId"],raw:!0}):[]).reduce((e,t)=>{e[t.faqId]={positiveCount:parseInt(t.positiveCount,10),negativeCount:parseInt(t.negativeCount,10),totalFeedback:parseInt(t.totalFeedback,10)};return e},{}),C=v.map(e=>{const t=h[e.id]||{positiveCount:0,totalFeedback:0},i=t.totalFeedback>0?t.positiveCount/t.totalFeedback*100:0;return{id:e.id,title:e.question,views:e.views,category:e.category,positiveRating:i}}),N=q.map(e=>{const t=parseInt(e.count,10),i=u?t/u*100:0;return{category:e.category,count:t,percentage:i}}),T=f.map(e=>({query:e.query,count:parseInt(e.count,10),averageResults:parseFloat(e.averageResults)})),H=g.map(e=>({date:e.date,positive:parseInt(e.positive,10),negative:parseInt(e.negative,10)})),D=_.reduce((e,t)=>{e[t.month]=parseInt(t.views,10);return e},{}),I=[];for(let t=1;t<=12;t++){const i=`${e}-${t.toString().padStart(2,"0")}-01`;I.push({month:i,views:D[i]||0})}const O=m.reduce((e,t)=>{e[t.month]={positive:parseInt(t.positive,10),negative:parseInt(t.negative,10)};return e},{}),k=[];for(let a=1;a<=12;a++){const s=`${e}-${a.toString().padStart(2,"0")}-01`;k.push({month:s,positive:(null===(t=O[s])||void 0===t?void 0:t.positive)||0,negative:(null===(i=O[s])||void 0===i?void 0:i.negative)||0})}const M=(new Date).getMonth()+1,R=`${e}-${M.toString().padStart(2,"0")}-01`,U=M>1?`${e}-${(M-1).toString().padStart(2,"0")}-01`:null,Q=(null===(a=I.find(e=>e.month===R))||void 0===a?void 0:a.views)||0,j=U&&(null===(s=I.find(e=>e.month===U))||void 0===s?void 0:s.views)||0,$=Q-j,L=j?$/j*100:Q>0?100:0,W=k.find(e=>e.month===R)||{positive:0,negative:0},P=U&&k.find(e=>e.month===U)||{positive:0,negative:0},V=W.positive-P.positive,x=P.positive?V/P.positive*100:W.positive>0?100:0,Y=W.negative-P.negative,G=P.negative?Y/P.negative*100:W.negative>0?100:0;null==o||o.success("FAQ analytics retrieved successfully");return{totalFaqs:u,activeFaqs:c,totalViews:d,averageRating:z,positiveRatingPercentage:w,negativeRatingPercentage:F,viewsComparison:{current:Q,previous:j,delta:$,percentageChange:L},feedbackComparison:{positive:{current:W.positive,previous:P.positive,delta:V,percentageChange:x},negative:{current:W.negative,previous:P.negative,delta:Y,percentageChange:G}},mostViewedFaqs:C,categoryDistribution:N,topSearchQueries:T,feedbackOverTime:H,viewsOverTime:I}}catch(e){console.error("Error fetching FAQ analytics:",e);throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Failed to fetch analytics data"})}};