"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),utils_1=require("./utils"),chains_1=require("@b/api/(ext)/ecosystem/utils/chains"),schema_1=require("@b/utils/schema"),wallet_1=require("@b/api/(ext)/ecosystem/utils/wallet"),error_1=require("@b/utils/error");exports.metadata={summary:"Create a new ecosystem master wallet",description:"Creates a new master wallet for a specific blockchain. Generates a new wallet with private key, encrypts the sensitive data, and stores it securely in the database. The master wallet is used to manage custodial wallets and ecosystem transactions.",operationId:"createEcosystemMasterWallet",tags:["Admin","Ecosystem","Wallet"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{chain:(0,schema_1.baseStringSchema)("Blockchain chain associated with the master wallet",255)},required:["chain"]}}}},responses:(0,query_1.storeRecordResponses)(utils_1.ecosystemMasterWalletStoreSchema,"Ecosystem Master Wallet"),requiresAuth:!0,permission:"create.ecosystem.master.wallet",logModule:"ADMIN_ECO",logTitle:"Create Ecosystem Master Wallet"};exports.default=async e=>{const{body:t,ctx:s}=e,{chain:a}=t;null==s||s.step("Checking for Existing Master Wallet");if(await(0,wallet_1.getMasterWalletByChain)(a))throw(0,error_1.createError)({statusCode:409,message:`Master wallet already exists: ${a}`});null==s||s.step("Creating and Encrypting Wallet");const r=await(0,utils_1.createAndEncryptWallet)(a,s);null==s||s.step("Storing Master Wallet");const l=await(0,utils_1.createMasterWallet)(r,chains_1.chainConfigs[a].currency,s);null==s||s.success(`Master wallet created successfully for chain: ${a}`);return l};