"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"List ecosystem private ledger entries",operationId:"listEcosystemPrivateLedgers",tags:["Admin","Ecosystem","Ledger"],description:"Retrieves a paginated list of ecosystem private ledger entries. Each ledger entry tracks the offchain balance difference for a specific wallet, currency, and blockchain network combination. The response includes associated wallet information and user details.",parameters:constants_1.crudParameters,logModule:"ADMIN_ECO",logTitle:"List private ledgers",responses:{200:{description:"Successfully retrieved list of ecosystem private ledger entries with associated wallet and user information",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",properties:utils_1.ecosystemPrivateLedgerSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Ecosystem Private Ledgers"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"view.ecosystem.private.ledger",demoMask:["items.wallet.user.email"]};exports.default=async e=>{const{query:t,ctx:s}=e;null==s||s.step("Fetching private ledger entries");const r=await(0,query_1.getFiltered)({model:db_1.models.ecosystemPrivateLedger,query:t,sortField:t.sortField||"createdAt",includeModels:[{model:db_1.models.wallet,as:"wallet",attributes:["currency","address","balance"],includeModels:[{model:db_1.models.user,as:"user",attributes:["avatar","firstName","lastName","email"]}]}]}),a=r.items.filter(e=>{const t=`${e.chain.toUpperCase()}_NETWORK`,s=process.env[t];return!s||!e.network||e.network===s});null==s||s.success(`Retrieved ${a.length} private ledgers`);return{items:a,pagination:r.pagination}};