"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"Lists all ecommerce products with pagination and filtering",operationId:"listEcommerceProducts",tags:["Admin","Ecommerce","Product"],description:"Retrieves a paginated list of ecommerce products with optional filtering and sorting. Includes associated category information and reviews for each product.",parameters:constants_1.crudParameters,responses:{200:{description:"Ecommerce products retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",properties:utils_1.ecommerceProductSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Ecommerce Products"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"view.ecommerce.product"};exports.default=async e=>{var t;const{query:r,ctx:s}=e;null==s||s.step("Fetching products list");const o=await(0,query_1.getFiltered)({model:db_1.models.ecommerceProduct,query:r,sortField:r.sortField||"createdAt",includeModels:[{model:db_1.models.ecommerceCategory,as:"category",attributes:["name"]},{model:db_1.models.ecommerceReview,as:"ecommerceReviews",attributes:["rating","comment"],required:!1}],numericFields:["price","inventoryQuantity","rating"]});null==s||s.success(`Retrieved ${(null===(t=o.items)||void 0===t?void 0:t.length)||0} products`);return o};