"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),utils_1=require("./utils"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Creates a new ecommerce category",description:"Creates a new ecommerce category with the provided name, description, image, and status. The name must be unique across all categories.",operationId:"createEcommerceCategory",tags:["Admin","Ecommerce","Category"],requestBody:{required:!0,content:{"application/json":{schema:utils_1.ecommerceCategoryUpdateSchema}}},responses:{200:{description:"Category created successfully",content:{"application/json":{schema:{type:"object",properties:utils_1.ecommerceCategoryStoreSchema}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,409:(0,errors_1.conflictResponse)("Ecommerce category"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"create.ecommerce.category",logModule:"ADMIN_ECOM",logTitle:"Create category"};exports.default=async e=>{const{body:r,ctx:t}=e,{name:o,description:s,image:a,status:c}=r;null==t||t.step("Validating category data");null==t||t.step("Creating category record");const i=await(0,query_1.storeRecord)({model:"ecommerceCategory",data:{name:o,description:s,image:a,status:c}});null==t||t.success(`Category created: ${o}`);return i};