"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk deletes ecommerce categories",description:"Permanently deletes multiple ecommerce categories by their IDs. This operation cannot be undone. All related data will be affected according to the cascade rules defined in the database.",operationId:"bulkDeleteEcommerceCategories",tags:["Admin","Ecommerce","Category"],parameters:(0,query_1.commonBulkDeleteParams)("Ecommerce categories"),requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of ecommerce category IDs to delete"}},required:["ids"]}}}},responses:{200:{description:"Categories deleted successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Ecommerce category"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"delete.ecommerce.category",logModule:"ADMIN_ECOM",logTitle:"Bulk delete categories"};exports.default=async e=>{const{body:r,query:t,ctx:s}=e,{ids:o}=r;null==s||s.step(`Validating ${o.length} category IDs`);null==s||s.step("Performing bulk delete operation");const a=await(0,query_1.handleBulkDelete)({model:"ecommerceCategory",ids:o,query:t});null==s||s.success(`Successfully deleted ${o.length} categories`);return a};