"use strict";async function initializeAiMarketMakerTables(){var e,t;if(!initialized)try{await(0,client_1.initialize)();for(const t of aiMarketMakerTableQueries)try{await client_1.default.execute(t)}catch(t){(null===(e=t.message)||void 0===e?void 0:e.includes("already exists"))||console_1.logger.error("AI_MARKET_MAKER","Failed to create table in ScyllaDB",t)}for(const e of aiMarketMakerViewQueries)try{await client_1.default.execute(e)}catch(e){(null===(t=e.message)||void 0===t?void 0:t.includes("already exists"))||console_1.logger.error("AI_MARKET_MAKER","Failed to create materialized view in ScyllaDB",e)}initialized=!0;console_1.logger.groupItem("AI_MM","Database tables initialized","success")}catch(e){console_1.logger.groupItem("AI_MM",`Failed to initialize database tables: ${e instanceof Error?e.message:e}`,"error");throw e}}function isInitialized(){return initialized}var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,r,a){void 0===a&&(a=r);var i=Object.getOwnPropertyDescriptor(t,r);i&&!("get"in i?!t.__esModule:i.writable||i.configurable)||(i={enumerable:!0,get:function(){return t[r]}});Object.defineProperty(e,a,i)}:function(e,t,r,a){void 0===a&&(a=r);e[a]=t[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[t.length]=r);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var r={};if(null!=t)for(var a=e(t),i=0;i<a.length;i++)"default"!==a[i]&&__createBinding(r,t,a[i]);__setModuleDefault(r,t);return r}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.scyllaKeyspace=exports.client=exports.aiMarketMakerKeyspace=void 0;exports.initializeAiMarketMakerTables=initializeAiMarketMakerTables;exports.isInitialized=isInitialized;const client_1=__importStar(require("@b/api/(ext)/ecosystem/utils/scylla/client"));exports.client=client_1.default;Object.defineProperty(exports,"scyllaKeyspace",{enumerable:!0,get:function(){return client_1.scyllaKeyspace}});const console_1=require("@b/utils/console");exports.aiMarketMakerKeyspace=client_1.scyllaKeyspace;const aiMarketMakerTableQueries=[`CREATE TABLE IF NOT EXISTS ${exports.aiMarketMakerKeyspace}.ai_bot_orders (\n    market_id UUID,\n    bot_id UUID,\n    order_id UUID,\n    side TEXT,\n    type TEXT,\n    price VARINT,\n    amount VARINT,\n    filled_amount VARINT,\n    status TEXT,\n    purpose TEXT,\n    matched_with_bot_id UUID,\n    created_at TIMESTAMP,\n    updated_at TIMESTAMP,\n    PRIMARY KEY ((market_id), created_at, order_id)\n  ) WITH CLUSTERING ORDER BY (created_at DESC, order_id ASC);`,`CREATE TABLE IF NOT EXISTS ${exports.aiMarketMakerKeyspace}.ai_bot_trades (\n    market_id UUID,\n    trade_date DATE,\n    trade_time TIMESTAMP,\n    trade_id UUID,\n    buy_bot_id UUID,\n    sell_bot_id UUID,\n    buy_order_id UUID,\n    sell_order_id UUID,\n    price VARINT,\n    amount VARINT,\n    PRIMARY KEY ((market_id, trade_date), trade_time, trade_id)\n  ) WITH CLUSTERING ORDER BY (trade_time DESC, trade_id ASC);`,`CREATE TABLE IF NOT EXISTS ${exports.aiMarketMakerKeyspace}.ai_price_history (\n    market_id UUID,\n    timestamp TIMESTAMP,\n    price VARINT,\n    volume VARINT,\n    is_ai_trade BOOLEAN,\n    source TEXT,\n    PRIMARY KEY ((market_id), timestamp)\n  ) WITH CLUSTERING ORDER BY (timestamp DESC);`,`CREATE TABLE IF NOT EXISTS ${exports.aiMarketMakerKeyspace}.ai_real_liquidity_orders (\n    ai_order_id UUID,\n    ecosystem_order_id UUID,\n    bot_id UUID,\n    market_id UUID,\n    symbol TEXT,\n    side TEXT,\n    price VARINT,\n    amount VARINT,\n    filled_amount VARINT,\n    status TEXT,\n    created_at TIMESTAMP,\n    updated_at TIMESTAMP,\n    PRIMARY KEY ((ecosystem_order_id))\n  );`,`CREATE TABLE IF NOT EXISTS ${exports.aiMarketMakerKeyspace}.ai_bot_real_trades (\n    bot_id UUID,\n    trade_date DATE,\n    trade_time TIMESTAMP,\n    trade_id UUID,\n    market_id UUID,\n    symbol TEXT,\n    side TEXT,\n    price VARINT,\n    amount VARINT,\n    fee VARINT,\n    is_maker BOOLEAN,\n    counterparty_user_id UUID,\n    pnl VARINT,\n    PRIMARY KEY ((bot_id, trade_date), trade_time, trade_id)\n  ) WITH CLUSTERING ORDER BY (trade_time DESC, trade_id ASC);`],aiMarketMakerViewQueries=[`CREATE MATERIALIZED VIEW IF NOT EXISTS ${exports.aiMarketMakerKeyspace}.ai_bot_orders_by_bot AS\n  SELECT * FROM ${exports.aiMarketMakerKeyspace}.ai_bot_orders\n  WHERE bot_id IS NOT NULL AND market_id IS NOT NULL AND created_at IS NOT NULL AND order_id IS NOT NULL\n  PRIMARY KEY ((bot_id), created_at, order_id, market_id)\n  WITH CLUSTERING ORDER BY (created_at DESC, order_id ASC);`,`CREATE MATERIALIZED VIEW IF NOT EXISTS ${exports.aiMarketMakerKeyspace}.ai_bot_open_orders AS\n  SELECT * FROM ${exports.aiMarketMakerKeyspace}.ai_bot_orders\n  WHERE status = 'OPEN' AND market_id IS NOT NULL AND created_at IS NOT NULL AND order_id IS NOT NULL\n  PRIMARY KEY ((status, market_id), created_at, order_id)\n  WITH CLUSTERING ORDER BY (created_at DESC, order_id ASC);`,`CREATE MATERIALIZED VIEW IF NOT EXISTS ${exports.aiMarketMakerKeyspace}.ai_real_liquidity_orders_by_ai_order AS\n  SELECT * FROM ${exports.aiMarketMakerKeyspace}.ai_real_liquidity_orders\n  WHERE ai_order_id IS NOT NULL AND ecosystem_order_id IS NOT NULL\n  PRIMARY KEY ((ai_order_id), ecosystem_order_id);`];let initialized=!1;exports.default=client_1.default;