"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.TrendManager=void 0;const db_1=require("@b/db"),console_1=require("@b/utils/console"),PHASE_CONFIGS={ACCUMULATION:{durationRange:{min:24,max:72},priceTargetRange:{min:-5,max:2},volatilityMultiplier:.7},MARKUP:{durationRange:{min:48,max:168},priceTargetRange:{min:10,max:40},volatilityMultiplier:1.2},DISTRIBUTION:{durationRange:{min:24,max:48},priceTargetRange:{min:-3,max:3},volatilityMultiplier:1},MARKDOWN:{durationRange:{min:36,max:120},priceTargetRange:{min:-40,max:-10},volatilityMultiplier:1.5}},BASE_TRANSITIONS={ACCUMULATION:{ACCUMULATION:.15,MARKUP:.7,DISTRIBUTION:.1,MARKDOWN:.05},MARKUP:{ACCUMULATION:.05,MARKUP:.25,DISTRIBUTION:.65,MARKDOWN:.05},DISTRIBUTION:{ACCUMULATION:.1,MARKUP:.15,DISTRIBUTION:.1,MARKDOWN:.65},MARKDOWN:{ACCUMULATION:.7,MARKUP:.1,DISTRIBUTION:.05,MARKDOWN:.15}};class TrendManager{getPhaseContext(e,t,a,r,i){const n=new Date,s=r||n,o=i||new Date(n.getTime()+864e5),l=o.getTime()-s.getTime(),c=n.getTime()-s.getTime();return{phase:e,startPrice:t,targetPrice:a,progress:Math.min(1,Math.max(0,c/l)),startedAt:s,endsAt:o,durationHours:l/36e5}}shouldTransitionPhase(e){return!e||new Date>=e}calculateNextPhase(e,t,a){const r={...BASE_TRANSITIONS[e]},i=this.applyBias(r,t,a/100);return this.selectPhaseByProbability(i)}applyBias(e,t,a){const r={...e};if("NEUTRAL"===t||0===a)return r;const i=.5*a;if("BULLISH"===t){r.MARKUP*=1+i;r.ACCUMULATION*=1+.5*i;r.MARKDOWN*=1-i;r.DISTRIBUTION*=1-.3*i}else if("BEARISH"===t){r.MARKDOWN*=1+i;r.DISTRIBUTION*=1+.5*i;r.MARKUP*=1-i;r.ACCUMULATION*=1-.3*i}const n=Object.values(r).reduce((e,t)=>e+t,0);for(const e of Object.keys(r))r[e]/=n;return r}selectPhaseByProbability(e){const t=Math.random();let a=0;for(const[r,i]of Object.entries(e)){a+=i;if(t<=a)return r}return"ACCUMULATION"}calculatePhaseDuration(e){const t=PHASE_CONFIGS[e],{min:a,max:r}=t.durationRange,i=r-a,n=(Math.random()+Math.random()+Math.random())/3;return Math.round(a+i*n)}calculatePhaseTargetPrice(e,t,a,r){const i=PHASE_CONFIGS[e];let{min:n,max:s}=i.priceTargetRange;if(a&&r){const e=r/100;if("BULLISH"===a){const t=(s-n)*e*.3;n+=t;s+=t}else if("BEARISH"===a){const t=(s-n)*e*.3;n-=t;s-=t}}return t*(1+(n+Math.random()*(s-n))/100)}getVolatilityMultiplier(e){return PHASE_CONFIGS[e].volatilityMultiplier}async executePhaseTransition(e,t,a,r,i){const n=this.calculateNextPhase(a,r,i),s=this.calculatePhaseDuration(n),o=this.calculatePhaseTargetPrice(n,t,r,i),l=new Date,c=new Date(l.getTime()+60*s*60*1e3);try{await db_1.models.aiMarketMaker.update({currentPhase:n,phaseStartedAt:l,nextPhaseChangeAt:c,phaseTargetPrice:o,volatilityMultiplier:this.getVolatilityMultiplier(n)},{where:{id:e}});await db_1.models.aiMarketMakerHistory.create({marketMakerId:e,action:"PHASE_CHANGE",details:{previousPhase:a,newPhase:n,phaseDuration:s,phaseTargetPrice:o,triggeredBy:"SYSTEM"},priceAtAction:t,poolValueAtAction:0});console_1.logger.info("AI_MM",`Phase transition: ${a} -> ${n} | Target: ${o.toFixed(6)} | Duration: ${s}h`)}catch(e){console_1.logger.error("AI_MM","Failed to execute phase transition",e);throw e}return{newPhase:n,phaseTargetPrice:o,phaseStartedAt:l,nextPhaseChangeAt:c,durationHours:s}}async forcePhaseTransition(e,t,a,r,i){const n=this.calculatePhaseDuration(r),s=this.calculatePhaseTargetPrice(r,t),o=new Date,l=new Date(o.getTime()+60*n*60*1e3);try{await db_1.models.aiMarketMaker.update({currentPhase:r,phaseStartedAt:o,nextPhaseChangeAt:l,phaseTargetPrice:s,volatilityMultiplier:this.getVolatilityMultiplier(r)},{where:{id:e}});await db_1.models.aiMarketMakerHistory.create({marketMakerId:e,action:"PHASE_CHANGE",details:{previousPhase:a,newPhase:r,phaseDuration:n,phaseTargetPrice:s,triggeredBy:"ADMIN",adminId:i,note:"Forced phase transition"},priceAtAction:t,poolValueAtAction:0});console_1.logger.warn("AI_MM",`ADMIN forced phase transition: ${a} -> ${r}`)}catch(e){console_1.logger.error("AI_MM","Failed to force phase transition",e);throw e}return{newPhase:r,phaseTargetPrice:s,phaseStartedAt:o,nextPhaseChangeAt:l,durationHours:n}}async initializePhase(e,t,a="NEUTRAL",r=50){const i="ACCUMULATION",n=this.calculatePhaseDuration(i),s=this.calculatePhaseTargetPrice(i,t,a,r),o=new Date,l=new Date(o.getTime()+60*n*60*1e3);await db_1.models.aiMarketMaker.update({currentPhase:i,phaseStartedAt:o,nextPhaseChangeAt:l,phaseTargetPrice:s,volatilityMultiplier:this.getVolatilityMultiplier(i)},{where:{id:e}});console_1.logger.info("AI_MM",`Initialized phase for market maker ${e}: ${i}`);return{phase:i,phaseTargetPrice:s,phaseStartedAt:o,nextPhaseChangeAt:l}}getPhaseConfig(e){return{...PHASE_CONFIGS[e]}}getAllPhaseConfigs(){return{...PHASE_CONFIGS}}}exports.TrendManager=TrendManager;exports.default=TrendManager;