"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.ExternalPriceSync=void 0;const exchange_1=__importDefault(require("@b/utils/exchange")),redis_1=require("@b/utils/redis"),console_1=require("@b/utils/console"),redis=redis_1.RedisSingleton.getInstance(),PRICE_CACHE_TTL=5;class ExternalPriceSync{constructor(){this.exchangeManager=exchange_1.default}async getExternalPrice(e){var t,r;const a=`external_price:${e}`;try{const e=await redis.get(a);if(e)return parseFloat(e)}catch(e){}try{const t=await this.exchangeManager.startExchange();if(!t){console_1.logger.debug("AI_MM","No exchange provider available for external price");return null}const r=await t.fetchTicker(e);if(!r||!r.last){console_1.logger.debug("AI_MM",`No ticker data for ${e}`);return null}const n=r.last;try{await redis.set(a,n.toString(),"EX",5)}catch(e){}return n}catch(a){(null===(t=a.message)||void 0===t?void 0:t.includes("not found"))||(null===(r=a.message)||void 0===r?void 0:r.includes("does not exist"))?console_1.logger.debug("AI_MM",`Symbol ${e} not found on exchange`):console_1.logger.error("AI_MM",`Error fetching external price for ${e}`,a);return null}}calculateGravityEffect(e,t,r){const a=(t-e)/e*100,n=r/100*Math.min(Math.abs(a)/10,1);return{targetPrice:e*(1-n)+t*n,pullStrength:n,divergence:a,externalPrice:t}}smoothPriceTransition(e,t,r=.5){const a=t-e,n=e*(r/100);if(Math.abs(a)<=n)return t;return e+(a>0?n:-n)}async getGravityAdjustedTarget(e,t,r){const a=await this.getExternalPrice(t);return a?this.calculateGravityEffect(e,a,r):null}async isSymbolAvailable(e){const t=`symbol_available:${e}`;try{const e=await redis.get(t);if(null!==e)return"1"===e}catch(e){}try{const r=await this.exchangeManager.startExchange();if(!r)return!1;r.markets||await r.loadMarkets();const a=e in r.markets;try{await redis.set(t,a?"1":"0","EX",3600)}catch(e){}return a}catch(t){console_1.logger.error("AI_MM",`Error checking symbol availability for ${e}`,t);return!1}}async getAvailableSymbols(){try{const e=await this.exchangeManager.startExchange();if(!e)return[];e.markets||await e.loadMarkets();return Object.keys(e.markets||{})}catch(e){console_1.logger.error("AI_MM","Error fetching available symbols",e);return[]}}calculateCorrelation(e){if(e.length<2)return 0;const t=e.length,r=e.map(e=>e.internal),a=e.map(e=>e.external),n=r.reduce((e,t)=>e+t,0)/t,c=a.reduce((e,t)=>e+t,0)/t;let s=0,l=0,i=0;for(let e=0;e<t;e++){const t=r[e]-n,o=a[e]-c;s+=t*o;l+=t*t;i+=o*o}const o=Math.sqrt(l*i);return 0===o?0:s/o}mapToExchangeSymbol(e){const t=e.split("/");return 2!==t.length?e:`${t[0].toUpperCase()}/${t[1].toUpperCase()}`}async clearPriceCache(e){try{await redis.del(`external_price:${e}`)}catch(e){}}async clearAllCaches(){try{const e=await redis.keys("external_price:*");e.length>0&&await redis.del(...e)}catch(e){console_1.logger.error("AI_MM","Error clearing external price caches",e)}}}exports.ExternalPriceSync=ExternalPriceSync;exports.default=ExternalPriceSync;