"use strict";async function processAiMarketMakerEngine(){const a="processAiMarketMakerEngine",e=Date.now();if(cronInProgress)(0,broadcast_1.broadcastLog)(a,"Previous execution still in progress, skipping","info");else if(!(e-lastExecutionTime<MIN_EXECUTION_INTERVAL_MS)){cronInProgress=!0;lastExecutionTime=e;try{(0,broadcast_1.broadcastStatus)(a,"running");const t=await getGlobalSettings();if(!t.tradingEnabled){if(engineInitialized&&"RUNNING"===MarketMakerEngine_1.default.getStatus().status){(0,broadcast_1.broadcastLog)(a,"AI Market Maker disabled, shutting down engine","warning");await MarketMakerEngine_1.default.shutdown();engineInitialized=!1}(0,broadcast_1.broadcastLog)(a,"AI Market Maker is disabled globally","info");(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});return}if(t.maintenanceMode){if(engineInitialized&&"RUNNING"===MarketMakerEngine_1.default.getStatus().status){(0,broadcast_1.broadcastLog)(a,"Maintenance mode, shutting down engine","warning");await MarketMakerEngine_1.default.shutdown();engineInitialized=!1}(0,broadcast_1.broadcastLog)(a,"AI Market Maker is in maintenance mode","info");(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});return}if(t.globalPauseEnabled){(0,broadcast_1.broadcastLog)(a,"AI Market Maker is globally paused","info");(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});return}const r=MarketMakerEngine_1.default.getStatus();if(!engineInitialized||"STOPPED"===r.status){(0,broadcast_1.broadcastLog)(a,"Initializing AI Market Maker Engine...","info");try{await MarketMakerEngine_1.default.initialize({tickIntervalMs:1e3,maxConcurrentMarkets:t.maxConcurrentBots||50,enableRealLiquidity:!0,emergencyStopEnabled:!0});engineInitialized=!0;(0,broadcast_1.broadcastLog)(a,"AI Market Maker Engine initialized successfully","success")}catch(e){console_1.logger.error("AI_MARKET_MAKER","Failed to initialize engine",e);(0,broadcast_1.broadcastLog)(a,`Failed to initialize engine: ${e.message}`,"error");(0,broadcast_1.broadcastStatus)(a,"failed");return}}const o=MarketMakerEngine_1.default.getStatus();(0,broadcast_1.broadcastLog)(a,`Engine running: ${o.activeMarkets} markets, ${o.tickCount} ticks, ${o.errorCount} errors`,"info");await syncMarketStatuses(MarketMakerEngine_1.default);(0,broadcast_1.broadcastProgress)(a,100);(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e})}catch(e){console_1.logger.error("AI_MARKET_MAKER","AI Market Maker Engine failed",e);(0,broadcast_1.broadcastStatus)(a,"failed");(0,broadcast_1.broadcastLog)(a,`AI Market Maker Engine failed: ${e.message}`,"error")}finally{cronInProgress=!1}}}async function syncMarketStatuses(a){var e,t;const r="processAiMarketMakerEngine",o=a.getMarketManager();if(o)try{const a=await db_1.models.aiMarketMaker.findAll({include:[{model:db_1.models.aiMarketMakerPool,as:"pool"},{model:db_1.models.ecosystemMarket,as:"market"},{model:db_1.models.aiBot,as:"bots"}]});for(const s of a){const a=s,i=o.isMarketActive(a.id);if("ACTIVE"!==a.status||i){if("STOPPED"===a.status&&i){(0,broadcast_1.broadcastLog)(r,`Stopping market ${(null===(t=a.market)||void 0===t?void 0:t.symbol)||a.id}`,"info");await o.stopMarket(a.id)}}else{(0,broadcast_1.broadcastLog)(r,`Starting market ${(null===(e=a.market)||void 0===e?void 0:e.symbol)||a.id}`,"info");await o.startMarket(a)}}}catch(a){console_1.logger.error("AI_MARKET_MAKER","Failed to sync market statuses",a);(0,broadcast_1.broadcastLog)(r,`Failed to sync market statuses: ${a.message}`,"error")}}async function getGlobalSettings(){try{const a=cache_1.CacheManager.getInstance(),[e,t,r,o]=await Promise.all([a.getSetting("aiMarketMakerEnabled"),a.getSetting("aiMarketMakerGlobalPauseEnabled"),a.getSetting("aiMarketMakerMaintenanceMode"),a.getSetting("aiMarketMakerMaxConcurrentBots")]);return{tradingEnabled:!1!==e,globalPauseEnabled:!0===t,maintenanceMode:!0===r,maxConcurrentBots:o||50}}catch(a){console_1.logger.error("AI_SETTINGS","Failed to get global settings",a);return{tradingEnabled:!0,globalPauseEnabled:!1,maintenanceMode:!1,maxConcurrentBots:50}}}async function processAiRiskMonitor(){const a="processAiRiskMonitor",e=Date.now();try{(0,broadcast_1.broadcastStatus)(a,"running");(0,broadcast_1.broadcastLog)(a,"Starting AI Risk Monitor check");const t=await getAiMarketMakerSettings();if(!t.tradingEnabled){(0,broadcast_1.broadcastLog)(a,"AI Market Maker disabled, skipping risk check","info");(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});return}const r=await db_1.models.aiMarketMaker.findAll({where:{status:{[sequelize_1.Op.in]:["ACTIVE","PAUSED"]}},include:[{model:db_1.models.aiMarketMakerPool,as:"pool"},{model:db_1.models.ecosystemMarket,as:"market"}]}),o=r.length;if(0===o){(0,broadcast_1.broadcastLog)(a,"No active markets to monitor","info");(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});return}(0,broadcast_1.broadcastLog)(a,`Monitoring ${o} markets for risk`);const s=[];for(let e=0;e<o;e++){const i=r[e];try{const a=await checkMarketRisk(i,t);s.push(...a)}catch(a){console_1.logger.error("AI_RISK_MONITOR",`Failed to check risk for market ${i.id}`,a)}const n=Math.round((e+1)/o*100);(0,broadcast_1.broadcastProgress)(a,n)}if(s.length>0){(0,broadcast_1.broadcastLog)(a,`Risk alerts found: ${s.length}`,"warning");for(const e of s)(0,broadcast_1.broadcastLog)(a,e,"warning")}(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});(0,broadcast_1.broadcastLog)(a,`AI Risk Monitor completed in ${Date.now()-e}ms`,"success")}catch(e){console_1.logger.error("AI_RISK_MONITOR","AI Risk Monitor failed",e);(0,broadcast_1.broadcastStatus)(a,"failed");(0,broadcast_1.broadcastLog)(a,`AI Risk Monitor failed: ${e.message}`,"error");throw e}}async function checkMarketRisk(a,e){var t;const r=[],o=a.pool,s=(null===(t=a.market)||void 0===t?void 0:t.symbol)||a.id;if(a.volatilityPauseEnabled){const t=await calculateVolatility(a.id),o=a.volatilityThreshold||e.defaultVolatilityThreshold;if(t>o){r.push(`High volatility detected for ${s}: ${t.toFixed(2)}% (threshold: ${o}%)`);if("ACTIVE"===a.status){await pauseMarketForVolatility(a);r.push(`Market ${s} auto-paused due to high volatility`)}}}if(o){const t=await calculateDailyPnL(a.id)/(Number(o.totalValueLocked)||1)*-100;if(t>e.maxDailyLossPercent){r.push(`Daily loss limit exceeded for ${s}: ${t.toFixed(2)}%`);if("ACTIVE"===a.status){await pauseMarketForLoss(a,t);r.push(`Market ${s} auto-paused due to daily loss limit`)}}}if("ACTIVE"===a.status){const e=await getLastTradeTime(a.id),t=new Date(Date.now()-36e5);e&&e<t&&r.push(`Market ${s} has been inactive for over an hour`)}if(o){const e=Number(o.baseBalance)*Number(a.targetPrice),t=e+Number(o.quoteBalance);if(t>0){const a=e/t;(a<.1||a>.9)&&r.push(`Pool imbalance detected for ${s}: Base ${(100*a).toFixed(1)}%`)}}o&&Number(o.totalValueLocked)<e.minLiquidity&&r.push(`Low liquidity warning for ${s}: ${Number(o.totalValueLocked).toFixed(2)}`);return r}async function calculateVolatility(a){try{const e=new Date(Date.now()-36e5),t=await db_1.models.aiMarketMakerHistory.findAll({where:{marketMakerId:a,action:{[sequelize_1.Op.in]:["TRADE","TARGET_CHANGE"]},createdAt:{[sequelize_1.Op.gte]:e}},order:[["createdAt","ASC"]]});if(t.length<2)return 0;const r=t.map(a=>Number(a.priceAtAction)),o=[];for(let a=1;a<r.length;a++)o.push((r[a]-r[a-1])/r[a-1]);if(0===o.length)return 0;const s=o.reduce((a,e)=>a+e,0)/o.length,i=o.reduce((a,e)=>a+Math.pow(e-s,2),0)/o.length;return Math.sqrt(i)*Math.sqrt(8760)*100}catch(a){console_1.logger.error("AI_MM","Failed to calculate volatility",a);return 0}}async function calculateDailyPnL(a){try{const e=new Date;e.setHours(0,0,0,0);return(await db_1.models.aiMarketMakerHistory.findAll({where:{marketMakerId:a,action:"TRADE",createdAt:{[sequelize_1.Op.gte]:e}}})).reduce((a,e)=>{var t;return a+((null===(t=e.details)||void 0===t?void 0:t.pnl)||0)},0)}catch(a){console_1.logger.error("AI_MM","Failed to calculate daily PnL",a);return 0}}async function getLastTradeTime(a){try{const e=await db_1.models.aiMarketMakerHistory.findOne({where:{marketMakerId:a,action:"TRADE"},order:[["createdAt","DESC"]]});return e?e.createdAt:null}catch(a){console_1.logger.error("AI_MM","Failed to get last trade time",a);return null}}async function pauseMarketForVolatility(a){var e;try{await db_1.models.aiMarketMaker.update({status:"PAUSED"},{where:{id:a.id}});await db_1.models.aiBot.update({status:"PAUSED"},{where:{marketMakerId:a.id,status:"ACTIVE"}});await db_1.models.aiMarketMakerHistory.create({marketMakerId:a.id,action:"AUTO_PAUSE",details:{reason:"HIGH_VOLATILITY",message:"Market automatically paused due to high volatility"},priceAtAction:a.targetPrice,poolValueAtAction:Number((null===(e=a.pool)||void 0===e?void 0:e.totalValueLocked)||0)})}catch(a){console_1.logger.error("AI_MM","Failed to pause market for volatility",a)}}async function pauseMarketForLoss(a,e){var t;try{await db_1.models.aiMarketMaker.update({status:"PAUSED"},{where:{id:a.id}});await db_1.models.aiBot.update({status:"PAUSED"},{where:{marketMakerId:a.id,status:"ACTIVE"}});await db_1.models.aiMarketMakerHistory.create({marketMakerId:a.id,action:"AUTO_PAUSE",details:{reason:"DAILY_LOSS_LIMIT",message:`Market paused due to daily loss limit (${e.toFixed(2)}%)`,lossPercent:e},priceAtAction:a.targetPrice,poolValueAtAction:Number((null===(t=a.pool)||void 0===t?void 0:t.totalValueLocked)||0)})}catch(a){console_1.logger.error("AI_MM","Failed to pause market for loss",a)}}async function getAiMarketMakerSettings(){try{const a=cache_1.CacheManager.getInstance(),[e,t,r,o,s]=await Promise.all([a.getSetting("aiMarketMakerEnabled"),a.getSetting("aiMarketMakerMaxDailyLossPercent"),a.getSetting("aiMarketMakerDefaultVolatilityThreshold"),a.getSetting("aiMarketMakerMinLiquidity"),a.getSetting("aiMarketMakerStopLossEnabled")]);return{tradingEnabled:!1!==e,maxDailyLossPercent:t||5,defaultVolatilityThreshold:r||10,minLiquidity:o||100,stopLossEnabled:!1!==s}}catch(a){console_1.logger.error("AI_MM","Failed to get AI market maker settings",a);return{tradingEnabled:!0,maxDailyLossPercent:5,defaultVolatilityThreshold:10,minLiquidity:100,stopLossEnabled:!0}}}async function processAiPoolRebalancer(){const a="processAiPoolRebalancer",e=Date.now();try{(0,broadcast_1.broadcastStatus)(a,"running");(0,broadcast_1.broadcastLog)(a,"Starting AI Pool Rebalancer");const t=cache_1.CacheManager.getInstance(),r=await t.getSetting("aiMarketMakerEnabled");if(!(!0===r||"true"===r)){(0,broadcast_1.broadcastLog)(a,"AI Market Maker disabled, skipping rebalance","info");(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});return}const o=await db_1.models.aiMarketMaker.findAll({where:{status:{[sequelize_1.Op.in]:["ACTIVE","PAUSED"]}},include:[{model:db_1.models.aiMarketMakerPool,as:"pool"},{model:db_1.models.ecosystemMarket,as:"market"}]}),s=o.length;if(0===s){(0,broadcast_1.broadcastLog)(a,"No markets with pools to check","info");(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});return}(0,broadcast_1.broadcastLog)(a,`Checking ${s} pools for rebalancing`);let i=0;for(let e=0;e<s;e++){const t=o[e],r=t.pool;if(r){try{if(checkPoolNeedsRebalance(t,r)){await rebalancePool(t,r);i++}}catch(a){console_1.logger.error("AI_REBALANCER",`Failed to rebalance pool ${r.id}`,a)}(0,broadcast_1.broadcastProgress)(a,Math.round((e+1)/s*100))}}(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});(0,broadcast_1.broadcastLog)(a,`AI Pool Rebalancer completed. Rebalanced ${i} pools`,"success")}catch(e){console_1.logger.error("AI_REBALANCER","AI Pool Rebalancer failed",e);(0,broadcast_1.broadcastStatus)(a,"failed");throw e}}function checkPoolNeedsRebalance(a,e){const t=Number(e.baseBalance)||0,r=Number(e.quoteBalance)||0,o=t*(Number(a.targetPrice)||1),s=o+r;if(s<=0)return!1;const i=o/s;return i<.2||i>.8}async function rebalancePool(a,e){var t;const r="processAiPoolRebalancer",o=(null===(t=a.market)||void 0===t?void 0:t.symbol)||a.id,s=Number(e.baseBalance)||0,i=Number(e.quoteBalance)||0,n=Number(a.targetPrice)||1,c=s*n,d=c+i;if(d<=0)return;const l=c/d,u=.5*d/n,g=.5*d;(0,broadcast_1.broadcastLog)(r,`Rebalancing ${o}: Base ${(100*l).toFixed(1)}% -> ${50..toFixed(1)}%`);await db_1.models.aiMarketMakerPool.update({baseBalance:u,quoteBalance:g,lastRebalanceAt:new Date},{where:{id:e.id}});await db_1.models.aiMarketMakerHistory.create({marketMakerId:a.id,action:"REBALANCE",details:{reason:"AUTO_REBALANCE",previousBaseBalance:s,previousQuoteBalance:i,newBaseBalance:u,newQuoteBalance:g,previousBaseRatio:l,newBaseRatio:.5},priceAtAction:n,poolValueAtAction:d});(0,broadcast_1.broadcastLog)(r,`Pool ${o} rebalanced`,"success")}async function processAiDailyReset(){const a="processAiDailyReset",e=Date.now();try{(0,broadcast_1.broadcastStatus)(a,"running");(0,broadcast_1.broadcastLog)(a,"Starting AI Daily Reset");(0,broadcast_1.broadcastLog)(a,"Generating daily summaries...");await generateDailySummaries();(0,broadcast_1.broadcastProgress)(a,25);(0,broadcast_1.broadcastLog)(a,"Resetting market daily volumes...");await resetMarketDailyVolumes();(0,broadcast_1.broadcastProgress)(a,50);(0,broadcast_1.broadcastLog)(a,"Resetting bot daily trade counts...");await resetBotDailyTradeCounts();(0,broadcast_1.broadcastProgress)(a,75);(0,broadcast_1.broadcastLog)(a,"Checking for markets to resume...");await resumeAutoPausedMarkets();(0,broadcast_1.broadcastProgress)(a,100);(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});(0,broadcast_1.broadcastLog)(a,`AI Daily Reset completed in ${Date.now()-e}ms`,"success")}catch(e){console_1.logger.error("AI_DAILY_RESET","AI Daily Reset failed",e);(0,broadcast_1.broadcastStatus)(a,"failed");throw e}}async function generateDailySummaries(){var a;const e=await db_1.models.aiMarketMaker.findAll({include:[{model:db_1.models.aiMarketMakerPool,as:"pool"},{model:db_1.models.ecosystemMarket,as:"market"}]}),t=new Date;t.setDate(t.getDate()-1);t.setHours(0,0,0,0);const r=new Date;r.setHours(0,0,0,0);for(const o of e)try{const e=await db_1.models.aiMarketMakerHistory.findAll({where:{marketMakerId:o.id,action:"TRADE",createdAt:{[sequelize_1.Op.gte]:t,[sequelize_1.Op.lt]:r}}});let s=0,i=0,n=0,c=0;for(const a of e){const e=a.details||{};s+=e.value||0;i+=e.pnl||0;"BUY"===e.side&&n++;"SELL"===e.side&&c++}await db_1.models.aiMarketMakerHistory.create({marketMakerId:o.id,action:"CONFIG_CHANGE",details:{type:"DAILY_SUMMARY",date:t.toISOString().split("T")[0],totalTrades:e.length,buyTrades:n,sellTrades:c,totalVolume:s,totalPnL:i},priceAtAction:o.targetPrice,poolValueAtAction:Number((null===(a=o.pool)||void 0===a?void 0:a.totalValueLocked)||0)})}catch(a){console_1.logger.error("AI_SUMMARY",`Failed to generate daily summary for market ${o.id}`,a)}}async function resetMarketDailyVolumes(){await db_1.models.aiMarketMaker.update({currentDailyVolume:0},{where:{}})}async function resetBotDailyTradeCounts(){await db_1.models.aiBot.update({dailyTradeCount:0},{where:{}})}async function resumeAutoPausedMarkets(){var a;const e=new Date;e.setDate(e.getDate()-1);e.setHours(0,0,0,0);const t=(await db_1.models.aiMarketMakerHistory.findAll({where:{action:"AUTO_PAUSE",createdAt:{[sequelize_1.Op.gte]:e}},attributes:["marketMakerId"],group:["marketMakerId"]})).map(a=>a.marketMakerId);if(0===t.length)return;const r=await db_1.models.aiMarketMaker.findAll({where:{id:{[sequelize_1.Op.in]:t},status:"PAUSED"}});for(const e of r)try{const t=await db_1.models.aiMarketMakerHistory.findOne({where:{marketMakerId:e.id,action:"AUTO_PAUSE"},order:[["createdAt","DESC"]]});if("DAILY_LOSS_LIMIT"===(null===(a=null==t?void 0:t.details)||void 0===a?void 0:a.reason)){await db_1.models.aiMarketMaker.update({status:"ACTIVE"},{where:{id:e.id}});await db_1.models.aiBot.update({status:"ACTIVE"},{where:{marketMakerId:e.id,status:"PAUSED"}});await db_1.models.aiMarketMakerHistory.create({marketMakerId:e.id,action:"RESUME",details:{reason:"DAILY_RESET",message:"Market automatically resumed after daily reset"},priceAtAction:e.targetPrice,poolValueAtAction:0})}}catch(a){console_1.logger.error("AI_MM",`Failed to resume auto-paused market ${e.id}`,a)}}async function processAiAnalyticsAggregator(){const a="processAiAnalyticsAggregator",e=Date.now();try{(0,broadcast_1.broadcastStatus)(a,"running");(0,broadcast_1.broadcastLog)(a,"Starting AI Analytics Aggregator");const t=await db_1.models.aiMarketMaker.findAll({include:[{model:db_1.models.aiMarketMakerPool,as:"pool"},{model:db_1.models.ecosystemMarket,as:"market"},{model:db_1.models.aiBot,as:"bots"}]}),r=t.length;if(0===r){(0,broadcast_1.broadcastLog)(a,"No markets to aggregate","info");(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});return}(0,broadcast_1.broadcastLog)(a,`Aggregating analytics for ${r} markets`);for(let e=0;e<r;e++){const o=t[e];try{await aggregateMarketAnalytics(o)}catch(a){console_1.logger.error("AI_MM",`Failed to aggregate market analytics for ${o.id}`,a)}(0,broadcast_1.broadcastProgress)(a,Math.round((e+1)/r*100))}await aggregateGlobalStats();(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});(0,broadcast_1.broadcastLog)(a,"AI Analytics Aggregator completed","success")}catch(e){console_1.logger.error("AI_ANALYTICS","AI Analytics Aggregator failed",e);(0,broadcast_1.broadcastStatus)(a,"failed");throw e}}async function aggregateMarketAnalytics(a){const e=a.pool,t=new Date(Date.now()-6048e5),r=await db_1.models.aiMarketMakerHistory.findAll({where:{marketMakerId:a.id,action:"TRADE",createdAt:{[sequelize_1.Op.gte]:t}}});if(e){const a=r.reduce((a,e)=>{var t;return a+((null===(t=e.details)||void 0===t?void 0:t.pnl)||0)},0);await db_1.models.aiMarketMakerPool.update({realizedPnL:a},{where:{id:e.id}})}}async function aggregateGlobalStats(){const a=await db_1.models.aiMarketMakerPool.findAll();let e=0;for(const t of a)e+=Number(t.totalValueLocked||0);const t=await db_1.models.aiMarketMaker.count({where:{status:"ACTIVE"}}),r=await db_1.models.aiBot.count({where:{status:"ACTIVE"}});(0,broadcast_1.broadcastLog)("processAiAnalyticsAggregator",`Global stats: TVL=$${e.toFixed(2)}, Markets=${t}, Bots=${r}`)}async function processAiPriceSync(){const a="processAiPriceSync",e=Date.now();try{(0,broadcast_1.broadcastStatus)(a,"running");(0,broadcast_1.broadcastLog)(a,"Starting AI Price Sync");const t=cache_1.CacheManager.getInstance(),r=await t.getSetting("aiMarketMakerEnabled");if(!(!0===r||"true"===r)){(0,broadcast_1.broadcastLog)(a,"AI Market Maker disabled, skipping price sync","info");(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});return}const o=await db_1.models.aiMarketMaker.findAll({where:{status:"ACTIVE"},include:[{model:db_1.models.ecosystemMarket,as:"market"}]}),s=o.length;if(0===s){(0,broadcast_1.broadcastLog)(a,"No active markets to sync prices","info");(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});return}(0,broadcast_1.broadcastLog)(a,`Syncing prices for ${s} active markets`);const i=[];for(let e=0;e<s;e++){const t=o[e];try{const a=await syncMarketPrice(t);i.push(...a)}catch(a){console_1.logger.error("AI_MM",`Failed to sync market price for ${t.id}`,a)}(0,broadcast_1.broadcastProgress)(a,Math.round((e+1)/s*100))}if(i.length>0)for(const e of i)(0,broadcast_1.broadcastLog)(a,e,"warning");(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-e});(0,broadcast_1.broadcastLog)(a,"AI Price Sync completed","success")}catch(e){console_1.logger.error("AI_PRICE_SYNC","AI Price Sync failed",e);(0,broadcast_1.broadcastStatus)(a,"failed");throw e}}async function syncMarketPrice(a){var e;const t=[],r=null===(e=a.market)||void 0===e?void 0:e.symbol;if(!r)return t;const o=await fetchExternalPrice(r);if(!o)return t;const s=Number(a.targetPrice),i=100*Math.abs((s-o)/o);if(i>10){t.push(`${r}: Target price $${s.toFixed(6)} deviates ${i.toFixed(2)}% from external $${o.toFixed(6)}`);await db_1.models.aiMarketMakerHistory.create({marketMakerId:a.id,action:"CONFIG_CHANGE",details:{type:"PRICE_DEVIATION_ALERT",targetPrice:s,externalPrice:o,deviation:i,symbol:r},priceAtAction:s,poolValueAtAction:0})}return t}async function fetchExternalPrice(a){const e=priceCache.get(a);if(e&&Date.now()-e.timestamp<PRICE_CACHE_TTL)return e.price;try{const[e,t]=a.split("/");if(!e||!t)return null;const r=await exchange_1.default.startExchange();if(!r)return null;const o=await r.fetchTicker(a);if(o&&o.last){const e=Number(o.last);priceCache.set(a,{price:e,timestamp:Date.now()});return e}return null}catch(a){return null}}function getCachedExternalPrice(a){const e=priceCache.get(a);return e&&Date.now()-e.timestamp<3*PRICE_CACHE_TTL?e.price:null}async function forceRefreshPrice(a){priceCache.delete(a);return fetchExternalPrice(a)}var __importDefault=this&&this.__importDefault||function(a){return a&&a.__esModule?a:{default:a}};Object.defineProperty(exports,"__esModule",{value:!0});exports.processAiMarketMakerEngine=processAiMarketMakerEngine;exports.processAiRiskMonitor=processAiRiskMonitor;exports.processAiPoolRebalancer=processAiPoolRebalancer;exports.processAiDailyReset=processAiDailyReset;exports.processAiAnalyticsAggregator=processAiAnalyticsAggregator;exports.processAiPriceSync=processAiPriceSync;exports.getCachedExternalPrice=getCachedExternalPrice;exports.forceRefreshPrice=forceRefreshPrice;const db_1=require("@b/db"),sequelize_1=require("sequelize"),console_1=require("@b/utils/console"),broadcast_1=require("@b/cron/broadcast"),cache_1=require("@b/utils/cache"),exchange_1=__importDefault(require("@b/utils/exchange")),MarketMakerEngine_1=__importDefault(require("./engine/MarketMakerEngine"));let engineInitialized=!1,cronInProgress=!1,lastExecutionTime=0;const MIN_EXECUTION_INTERVAL_MS=4e3,MIN_RATIO_THRESHOLD=.2,MAX_RATIO_THRESHOLD=.8,TARGET_RATIO=.5,PRICE_DEVIATION_ALERT_THRESHOLD=10,priceCache=new Map,PRICE_CACHE_TTL=1e4;