"use strict";function broadcastAiMarketMakerEvent(e,t){exports.aiMarketMakerHandler.broadcastEvent(e,t)}function broadcastBotActivity(e,t){exports.aiMarketMakerHandler.broadcastEvent(e,{type:"BOT_ACTIVITY",data:t})}Object.defineProperty(exports,"__esModule",{value:!0});exports.onClose=exports.aiMarketMakerHandler=exports.metadata=void 0;exports.broadcastAiMarketMakerEvent=broadcastAiMarketMakerEvent;exports.broadcastBotActivity=broadcastBotActivity;const Websocket_1=require("@b/handler/Websocket"),db_1=require("@b/db"),queries_1=require("../utils/scylla/queries"),console_1=require("@b/utils/console");exports.metadata={summary:"WebSocket connection for AI Market Maker market real-time updates",operationId:"connectAiMarketMakerMarketWebSocket",tags:["Admin","AI Market Maker","Market"],description:"Establishes a WebSocket connection for real-time updates on AI Market Maker markets. Event-driven architecture - sends initial data on subscription, then pushes updates only when events occur (trades, orders, status changes, bot activities). Supports subscribing/unsubscribing to specific market makers with automatic cleanup on disconnect.",requiresAuth:!0,permission:"view.ai.market-maker.market"};class AiMarketMakerDataHandler{constructor(){this.activeSubscriptions=new Map}static getInstance(){AiMarketMakerDataHandler.instance||(AiMarketMakerDataHandler.instance=new AiMarketMakerDataHandler);return AiMarketMakerDataHandler.instance}async sendInitialData(e){let t=null,a=null,r=[],i=[];const o=[];try{const r=await db_1.models.aiMarketMaker.findByPk(e,{include:[{model:db_1.models.aiMarketMakerPool,as:"pool"},{model:db_1.models.aiBot,as:"bots"},{model:db_1.models.ecosystemMarket,as:"market"}]});if(!r){console_1.logger.warn("AI_MM_WS",`Market maker ${e} not found`);return}t=r.get({plain:!0});a=t.market?`${t.market.currency}/${t.market.pair}`:null}catch(t){console_1.logger.error("AI_MM_WS",`Failed to fetch market maker ${e}`,t);o.push("Failed to load market maker data");return}if(a)try{r=await(0,queries_1.getRecentBotTrades)(t.marketId,20)}catch(t){console_1.logger.error("AI_MM_WS",`Failed to fetch recent trades for ${e}`,t);o.push("Failed to load recent trades")}try{i=await db_1.models.aiMarketMakerHistory.findAll({where:{marketMakerId:e},order:[["createdAt","DESC"]],limit:20})}catch(t){console_1.logger.error("AI_MM_WS",`Failed to fetch history for ${e}`,t);o.push("Failed to load activity history")}const s={stream:"ai-market-maker-data",data:{id:t.id,status:t.status,targetPrice:t.targetPrice,priceRangeLow:t.priceRangeLow,priceRangeHigh:t.priceRangeHigh,aggressionLevel:t.aggressionLevel,realLiquidityPercent:t.realLiquidityPercent,maxDailyVolume:t.maxDailyVolume,currentDailyVolume:t.currentDailyVolume,volatilityThreshold:t.volatilityThreshold,pauseOnHighVolatility:t.pauseOnHighVolatility,market:t.market?{id:t.market.id,currency:t.market.currency,pair:t.market.pair,symbol:a}:null,pool:t.pool?{id:t.pool.id,baseCurrencyBalance:t.pool.baseCurrencyBalance,quoteCurrencyBalance:t.pool.quoteCurrencyBalance,totalValueLocked:t.pool.totalValueLocked,realizedPnL:t.pool.realizedPnL,unrealizedPnL:t.pool.unrealizedPnL}:null,bots:(t.bots||[]).map(e=>({id:e.id,name:e.name,personality:e.personality,botType:e.personality,status:e.status,dailyTradeCount:e.dailyTradeCount,maxDailyTrades:e.maxDailyTrades,lastTradeAt:e.lastTradeAt,avgOrderSize:e.avgOrderSize,riskTolerance:e.riskTolerance,totalVolume:e.totalVolume,realTradesExecuted:e.realTradesExecuted,profitableTrades:e.profitableTrades,totalRealizedPnL:e.totalRealizedPnL,currentPosition:e.currentPosition,avgEntryPrice:e.avgEntryPrice})),recentTrades:r.map(e=>({id:e.id,price:e.price,amount:e.amount,buyBotId:e.buyBotId,sellBotId:e.sellBotId,createdAt:e.createdAt})),recentActivity:i.map(e=>({id:e.id,action:e.action,details:e.details,priceAtAction:e.priceAtAction,poolValueAtAction:e.poolValueAtAction,createdAt:e.createdAt})),errors:o.length>0?o:void 0}};Websocket_1.messageBroker.broadcastToSubscribedClients("/api/admin/ai/market-maker/market",{marketMakerId:e},s)}async addSubscription(e,t){if(!e){console_1.logger.warn("AI_MM_WS","No marketMakerId provided in subscription request");return}if(await db_1.models.aiMarketMaker.findByPk(e)){this.activeSubscriptions.has(e)||this.activeSubscriptions.set(e,new Set);this.activeSubscriptions.get(e).add(t);await this.sendInitialData(e);console_1.logger.info("AI_MM_WS",`Client ${t} subscribed to market maker ${e}`)}else console_1.logger.warn("AI_MM_WS",`Market maker ${e} not found`)}removeSubscription(e,t){if(this.activeSubscriptions.has(e)){this.activeSubscriptions.get(e).delete(t);0===this.activeSubscriptions.get(e).size&&this.activeSubscriptions.delete(e);console_1.logger.info("AI_MM_WS",`Client ${t} unsubscribed from market maker ${e}`)}}broadcastEvent(e,t){const a=this.activeSubscriptions.get(e);if(a&&0!==a.size){"development"===process.env.NODE_ENV&&console_1.logger.debug("AI_MM_WS",`Broadcasting ${t.type} to ${a.size} subscribers for market ${e}`);Websocket_1.messageBroker.broadcastToSubscribedClients("/api/admin/ai/market-maker/market",{marketMakerId:e},{stream:"ai-market-maker-event",data:{marketMakerId:e,timestamp:(new Date).toISOString(),...t}})}else"development"===process.env.NODE_ENV&&"TRADE"===t.type&&console_1.logger.debug("AI_MM_WS",`No subscribers for market ${e}, skipping ${t.type} broadcast`)}hasSubscribers(e){const t=this.activeSubscriptions.get(e);return!!t&&t.size>0}stop(){this.activeSubscriptions.clear()}removeClientFromAllSubscriptions(e){const t=[];for(const[a,r]of this.activeSubscriptions)if(r.has(e)){r.delete(e);0===r.size&&t.push(a)}for(const e of t)this.activeSubscriptions.delete(e);t.length>0&&console_1.logger.info("AI_MM_WS",`Cleaned up subscriptions for disconnected client ${e}`)}}exports.aiMarketMakerHandler=AiMarketMakerDataHandler.getInstance();exports.default=async(e,t)=>{var a;"string"==typeof t&&(t=JSON.parse(t));const{action:r,payload:i}=t,{marketMakerId:o}=i||{},s=null===(a=e.user)||void 0===a?void 0:a.id;if(!s){console_1.logger.error("AI_MM_WS","No client ID found");return}if(!o){console_1.logger.error("AI_MM_WS","No marketMakerId in payload");return}const n=AiMarketMakerDataHandler.getInstance();"SUBSCRIBE"===r?await n.addSubscription(o,s):"UNSUBSCRIBE"===r&&n.removeSubscription(o,s)};const onClose=(e,t,a)=>{AiMarketMakerDataHandler.getInstance().removeClientFromAllSubscriptions(a)};exports.onClose=onClose;