"use strict";function getDefaultBotConfigs(e){const r={CONSERVATIVE:{risk:.3,size:.5,trades:50},MODERATE:{risk:.5,size:1,trades:100},AGGRESSIVE:{risk:.8,size:2,trades:200}}[e];return[{name:"Scalper Alpha",personality:"SCALPER",tradeFrequency:"HIGH",preferredSpread:.001},{name:"Scalper Beta",personality:"SCALPER",tradeFrequency:"HIGH",preferredSpread:.0015},{name:"Swing Trader",personality:"SWING",tradeFrequency:"MEDIUM",preferredSpread:.003},{name:"Accumulator",personality:"ACCUMULATOR",tradeFrequency:"LOW",preferredSpread:.002},{name:"Distributor",personality:"DISTRIBUTOR",tradeFrequency:"LOW",preferredSpread:.002},{name:"Market Maker",personality:"MARKET_MAKER",tradeFrequency:"HIGH",preferredSpread:.001}].map(e=>({...e,riskTolerance:r.risk,avgOrderSize:100*r.size,orderSizeVariance:.2,maxDailyTrades:r.trades}))}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),utils_1=require("../utils"),errors_1=require("@b/utils/schema/errors"),error_1=require("@b/utils/error");exports.metadata={summary:"Create AI Market Maker market",operationId:"createAiMarketMakerMarket",tags:["Admin","AI Market Maker","Market"],description:"Creates a new AI Market Maker for an ecosystem market with specified configuration parameters. Automatically generates a liquidity pool, default bots based on aggression level, and initializes all necessary tracking structures. The market maker starts in STOPPED status and requires manual activation after initial funding.",logModule:"ADMIN_MM",logTitle:"Create AI Market Maker",requestBody:{required:!0,content:{"application/json":{schema:utils_1.aiMarketMakerCreateSchema}}},responses:{201:utils_1.aiMarketMakerStoreSchema,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"create.ai.market-maker.market"};exports.default=async e=>{const{body:r,ctx:a}=e,{marketId:t,targetPrice:i,priceRangeLow:o,priceRangeHigh:s,aggressionLevel:n="MODERATE",maxDailyVolume:l=1e6,volatilityThreshold:c=5,pauseOnHighVolatility:d=!0,realLiquidityPercent:u=20}=r;null==a||a.step("Validate ecosystem market exists");if(!await db_1.models.ecosystemMarket.findByPk(t))throw(0,error_1.createError)(404,"Ecosystem market not found");if(await db_1.models.aiMarketMaker.findOne({where:{marketId:t}}))throw(0,error_1.createError)(400,"AI Market Maker already exists for this market");null==a||a.step("Validate price parameters");if(i<=0)throw(0,error_1.createError)(400,"Target price must be greater than 0");if(o<=0)throw(0,error_1.createError)(400,"Price range low must be greater than 0");if(s<=0)throw(0,error_1.createError)(400,"Price range high must be greater than 0");if(o>=s)throw(0,error_1.createError)(400,"Price range low must be less than price range high");if(i<o||i>s)throw(0,error_1.createError)(400,"Target price must be within the price range");const m=(i-o)/i,k=(s-i)/i;if(m>.5||k>.5)throw(0,error_1.createError)(400,`Price range deviation from target must be within 50%. Current: low=${(100*m).toFixed(1)}%, high=${(100*k).toFixed(1)}%`);const p=1e-8;if(o<p||s<p||i<p)throw(0,error_1.createError)(400,"Price values must be at least 0.00000001 (8 decimal places)");if(u<0||u>100)throw(0,error_1.createError)(400,"Real liquidity percent must be between 0 and 100");null==a||a.step("Initialize database transaction");const M=await db_1.sequelize.transaction();try{null==a||a.step("Create AI Market Maker");const e=await db_1.models.aiMarketMaker.create({marketId:t,status:"STOPPED",targetPrice:i,priceRangeLow:o,priceRangeHigh:s,aggressionLevel:n,maxDailyVolume:l,currentDailyVolume:0,volatilityThreshold:c,pauseOnHighVolatility:d,realLiquidityPercent:u},{transaction:M});null==a||a.step("Create market maker pool");await db_1.models.aiMarketMakerPool.create({marketMakerId:e.id,baseCurrencyBalance:0,quoteCurrencyBalance:0,initialBaseBalance:0,initialQuoteBalance:0,totalValueLocked:0,unrealizedPnL:0,realizedPnL:0},{transaction:M});null==a||a.step("Create default bots");const r=getDefaultBotConfigs(n);for(const a of r)await db_1.models.aiBot.create({marketMakerId:e.id,...a,status:"PAUSED",dailyTradeCount:0},{transaction:M});null==a||a.step("Create history record");await db_1.models.aiMarketMakerHistory.create({marketMakerId:e.id,action:"START",details:{targetPrice:i,priceRangeLow:o,priceRangeHigh:s,aggressionLevel:n,realLiquidityPercent:u},priceAtAction:i,poolValueAtAction:0},{transaction:M});null==a||a.step("Commit transaction");await M.commit();null==a||a.success("AI Market Maker created successfully");return db_1.models.aiMarketMaker.findByPk(e.id,{include:[{model:db_1.models.aiMarketMakerPool,as:"pool"},{model:db_1.models.ecosystemMarket,as:"market"},{model:db_1.models.aiBot,as:"bots"}]})}catch(e){await M.rollback();throw e}};