"use strict";function getWeekNumber(e){const t=new Date(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate())),n=t.getUTCDay()||7;t.setUTCDate(t.getUTCDate()+4-n);const s=new Date(Date.UTC(t.getUTCFullYear(),0,1));return Math.ceil(((t.getTime()-s.getTime())/864e5+1)/7)}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Retrieves AI Investment dashboard statistics",description:"Retrieves comprehensive statistics for the AI Investment admin dashboard including total investments, active users, plan performance, investment results, financial metrics, and recent activity.",operationId:"getAiInvestmentDashboardStats",tags:["Admin","AI Investment","Dashboard"],requiresAuth:!0,parameters:[{name:"timeframe",in:"query",description:"Range of data to retrieve",required:!1,schema:{type:"string",enum:["1m","3m","1y"]}}],logModule:"ADMIN_AI",logTitle:"Get AI Investment Dashboard",responses:{200:{description:"AI Investment dashboard statistics retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{overview:{type:"object",properties:{totalInvestments:{type:"number"},totalAmount:{type:"number"},totalProfit:{type:"number"},activeInvestments:{type:"number"},completedInvestments:{type:"number"},cancelledInvestments:{type:"number"},rejectedInvestments:{type:"number"},winRate:{type:"number"},activePlans:{type:"number"},totalDurations:{type:"number"},spotInvestments:{type:"number"},ecoInvestments:{type:"number"},averageInvestment:{type:"number"}}},investmentResults:{type:"object",properties:{win:{type:"number"},loss:{type:"number"},draw:{type:"number"}}},chartData:{type:"array",items:{type:"object",properties:{name:{type:"string"},value:{type:"number"}}}},planDistribution:{type:"array",items:{type:"object",properties:{name:{type:"string"},value:{type:"number"},count:{type:"number"}}}},recentInvestments:{type:"array",items:{type:"object"}},topPlans:{type:"array",items:{type:"object"}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}},permission:"access.ai.investment"};exports.default=async e=>{const{user:t,query:n}=e,{timeframe:s="1y"}=n;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const a=new Date;let i,r,l,o;if("1m"===s){i=new Date(a.getFullYear(),a.getMonth(),1);r=new Date(a.getFullYear(),a.getMonth()+1,0);l="%d";const e=r.getDate();o=Array.from({length:e},(e,t)=>(t+1).toString())}else if("3m"===s){i=new Date(a.getFullYear(),a.getMonth()-2,1);r=new Date(a.getFullYear(),a.getMonth()+1,0);l="%Y-%u";const e=[],t=new Date(i);for(;t<=r;){e.push(`${t.getFullYear()}-${getWeekNumber(t)}`);t.setDate(t.getDate()+7)}o=e}else{i=new Date(a.getFullYear(),0,1);r=new Date(a.getFullYear(),11,31);l="%b";o=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]}const[u,m,d,p,v,c]=await Promise.all([db_1.models.aiInvestment.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("id")),"total"],[(0,sequelize_1.fn)("COALESCE",(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),0),"totalAmount"],[(0,sequelize_1.fn)("COALESCE",(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("profit")),0),"totalProfit"],[(0,sequelize_1.fn)("COALESCE",(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("amount")),0),"avgAmount"]],where:{status:{[sequelize_1.Op.ne]:"REJECTED"}},raw:!0}),db_1.models.aiInvestment.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN status = 'ACTIVE' THEN 1 END")),"active"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN status = 'COMPLETED' THEN 1 END")),"completed"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN status = 'CANCELLED' THEN 1 END")),"cancelled"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN status = 'REJECTED' THEN 1 END")),"rejected"]],raw:!0}),db_1.models.aiInvestment.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN result = 'WIN' THEN 1 END")),"win"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN result = 'LOSS' THEN 1 END")),"loss"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN result = 'DRAW' THEN 1 END")),"draw"]],where:{status:"COMPLETED"},raw:!0}),db_1.models.aiInvestment.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN type = 'SPOT' THEN 1 END")),"spot"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN type = 'ECO' THEN 1 END")),"eco"]],raw:!0}),db_1.models.aiInvestmentPlan.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN status = true THEN 1 END")),"active"]],raw:!0}),db_1.models.aiInvestmentDuration.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("id")),"total"]],raw:!0})]),E=parseInt((null==u?void 0:u.total)||"0",10),b=parseFloat((null==u?void 0:u.totalAmount)||"0"),I=parseFloat((null==u?void 0:u.totalProfit)||"0"),_=parseFloat((null==u?void 0:u.avgAmount)||"0"),f=parseInt((null==m?void 0:m.active)||"0",10),q=parseInt((null==m?void 0:m.completed)||"0",10),y=parseInt((null==m?void 0:m.cancelled)||"0",10),D=parseInt((null==m?void 0:m.rejected)||"0",10),N=parseInt((null==d?void 0:d.win)||"0",10),C=parseInt((null==d?void 0:d.loss)||"0",10),A=parseInt((null==d?void 0:d.draw)||"0",10),z=N+C+A,g=z>0?Math.round(N/z*100):0,w=parseInt((null==p?void 0:p.spot)||"0",10),T=parseInt((null==p?void 0:p.eco)||"0",10),O={totalInvestments:E,totalAmount:b,totalProfit:I,activeInvestments:f,completedInvestments:q,cancelledInvestments:y,rejectedInvestments:D,winRate:g,activePlans:parseInt((null==v?void 0:v.active)||"0",10),totalDurations:parseInt((null==c?void 0:c.total)||"0",10),spotInvestments:w,ecoInvestments:T,averageInvestment:_},h={win:N,loss:C,draw:A},S=await db_1.models.aiInvestment.findAll({attributes:[[(0,sequelize_1.fn)("DATE_FORMAT",(0,sequelize_1.col)("createdAt"),l),"period"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalInvested"]],where:{status:{[sequelize_1.Op.ne]:"REJECTED"},createdAt:{[sequelize_1.Op.between]:[i,r]}},group:["period"],raw:!0}),U={};S.forEach(e=>{U[e.period]=parseFloat(e.totalInvested)||0});return{overview:O,investmentResults:h,chartData:o.map(e=>({name:e,value:U[e]||0})),planDistribution:(await db_1.models.aiInvestmentPlan.findAll({attributes:["id","name",[(0,sequelize_1.fn)("COALESCE",(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("investments.amount")),0),"totalInvested"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("investments.id")),"investmentCount"]],include:[{model:db_1.models.aiInvestment,as:"investments",attributes:[],where:{status:{[sequelize_1.Op.ne]:"REJECTED"}},required:!1}],group:["aiInvestmentPlan.id"],raw:!0})).map(e=>({name:e.name,value:parseFloat(e.totalInvested)||0,count:parseInt(e.investmentCount||"0",10)})),recentInvestments:(await db_1.models.aiInvestment.findAll({include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]},{model:db_1.models.aiInvestmentPlan,as:"plan",attributes:["id","name","title"]},{model:db_1.models.aiInvestmentDuration,as:"duration",attributes:["id","duration","timeframe"]}],order:[["createdAt","DESC"]],limit:10,raw:!0,nest:!0})).map(e=>{var t,n;return{id:e.id,user:e.user&&`${e.user.firstName||""} ${e.user.lastName||""}`.trim()||"Unknown",userId:e.userId,userAvatar:null===(t=e.user)||void 0===t?void 0:t.avatar,plan:(null===(n=e.plan)||void 0===n?void 0:n.name)||"Unknown",planId:e.planId,duration:e.duration?`${e.duration.duration} ${e.duration.timeframe}`:"N/A",symbol:e.symbol,type:e.type,amount:e.amount,profit:e.profit||0,result:e.result,status:e.status,createdAt:e.createdAt}}),topPlans:await db_1.models.aiInvestmentPlan.findAll({attributes:["id","name","title","image","minAmount","maxAmount","minProfit","maxProfit","profitPercentage","invested","status","trending"],where:{status:!0},order:[["trending","DESC"],["invested","DESC"]],limit:5,raw:!0})}};