"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors"),utils_1=require("./utils");exports.metadata={summary:"Lists all affiliate referrals with pagination and filtering",description:"Retrieves a paginated list of all affiliate referral records in the system. Each referral includes information about the referrer and referred user. Supports filtering, sorting, and searching through query parameters.",operationId:"listAffiliateReferrals",tags:["Admin","Affiliate","Referral"],parameters:constants_1.crudParameters,responses:{200:{description:"List of affiliate referrals with pagination information",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",properties:utils_1.mlmReferralSchema}},pagination:constants_1.paginationSchema}}}}},401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Affiliate Referrals"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"view.affiliate.referral",logModule:"ADMIN_AFFILIATE",logTitle:"List affiliate referrals",demoMask:["items.referrer.email","items.referred.email"]};exports.default=async e=>{const{query:r,ctx:t}=e;null==t||t.step("Fetching affiliate referrals with user details");const s=(0,query_1.getFiltered)({model:db_1.models.mlmReferral,query:r,sortField:r.sortField||"createdAt",includeModels:[{model:db_1.models.user,as:"referrer",attributes:["id","firstName","lastName","email","avatar"]},{model:db_1.models.user,as:"referred",attributes:["id","firstName","lastName","email","avatar"]}]});null==t||t.success("Referrals fetched successfully");return s};