"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class wallet extends sequelize_1.Model{static initModel(e){return wallet.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}},comment:"ID of the user who owns this wallet"},type:{type:sequelize_1.DataTypes.ENUM("FIAT","SPOT","ECO","FUTURES","COPY_TRADING"),allowNull:!1,validate:{isIn:{args:[["FIAT","SPOT","ECO","FUTURES","COPY_TRADING"]],msg:"type: Type must be one of ['FIAT', 'SPOT', 'ECO', 'FUTURES', 'COPY_TRADING']"}},comment:"Type of wallet (FIAT for fiat currencies, SPOT for spot trading, ECO for ecosystem, FUTURES for futures trading)"},currency:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"currency: Currency cannot be empty"}},comment:"Currency symbol for this wallet (e.g., BTC, USD, ETH)"},balance:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"balance: Balance must be a number"}},comment:"Available balance in this wallet"},inOrder:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!0,defaultValue:0,comment:"Amount currently locked in open orders"},address:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("address");return e?JSON.parse(e):null},comment:"Blockchain addresses associated with this wallet"},status:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0,validate:{isBoolean:{msg:"status: Status must be a boolean"}},comment:"Whether this wallet is active and usable"}},{sequelize:e,modelName:"wallet",tableName:"wallet",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"walletIdKey",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"walletUserIdCurrencyTypeKey",unique:!0,using:"BTREE",fields:[{name:"userId"},{name:"currency"},{name:"type"}]}]})}static associate(e){wallet.hasMany(e.ecosystemPrivateLedger,{as:"ecosystemPrivateLedgers",foreignKey:"walletId",onDelete:"CASCADE",onUpdate:"CASCADE"});wallet.hasMany(e.ecosystemUtxo,{as:"ecosystemUtxos",foreignKey:"walletId",onDelete:"CASCADE",onUpdate:"CASCADE"});wallet.hasMany(e.transaction,{as:"transactions",foreignKey:"walletId",onDelete:"CASCADE",onUpdate:"CASCADE"});wallet.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});wallet.hasMany(e.walletData,{as:"walletData",foreignKey:"walletId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=wallet;