"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class nftReview extends sequelize_1.Model{static initModel(e){return nftReview.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}}},tokenId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"tokenId: Token ID must be a valid UUID"}}},collectionId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"collectionId: Collection ID must be a valid UUID"}}},creatorId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"creatorId: Creator ID must be a valid UUID"}}},rating:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,validate:{min:{args:[1],msg:"rating: Rating must be between 1 and 5"},max:{args:[5],msg:"rating: Rating must be between 1 and 5"}}},title:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,validate:{len:{args:[1,255],msg:"title: Title must be between 1 and 255 characters"}}},comment:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,validate:{len:{args:[1,2e3],msg:"comment: Comment must be between 1 and 2000 characters"}}},isVerified:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},helpfulCount:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0,validate:{min:{args:[0],msg:"helpfulCount: Helpful count must be non-negative"}}},status:{type:sequelize_1.DataTypes.ENUM("PENDING","APPROVED","REJECTED","HIDDEN"),allowNull:!1,defaultValue:"PENDING",validate:{isIn:{args:[["PENDING","APPROVED","REJECTED","HIDDEN"]],msg:"status: Status must be one of 'PENDING', 'APPROVED', 'REJECTED', or 'HIDDEN'"}}}},{sequelize:e,modelName:"nftReview",tableName:"nft_review",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"nftReviewUserIdx",using:"BTREE",fields:[{name:"userId"}]},{name:"nftReviewTokenIdx",using:"BTREE",fields:[{name:"tokenId"}]},{name:"nftReviewCollectionIdx",using:"BTREE",fields:[{name:"collectionId"}]},{name:"nftReviewCreatorIdx",using:"BTREE",fields:[{name:"creatorId"}]},{name:"nftReviewStatusIdx",using:"BTREE",fields:[{name:"status"}]},{name:"nftReviewRatingIdx",using:"BTREE",fields:[{name:"rating"}]},{name:"nftReviewVerifiedIdx",using:"BTREE",fields:[{name:"isVerified"}]}],validate:{hasReviewTarget(){if(!this.tokenId&&!this.collectionId&&!this.creatorId)throw new Error("Review must target either a token, collection, or creator")}}})}static associate(e){nftReview.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftReview.belongsTo(e.nftToken,{as:"token",foreignKey:"tokenId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftReview.belongsTo(e.nftCollection,{as:"collection",foreignKey:"collectionId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftReview.belongsTo(e.user,{as:"creator",foreignKey:"creatorId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=nftReview;