"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class nftBid extends sequelize_1.Model{static initModel(e){return nftBid.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},listingId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"listingId: Listing ID cannot be null"},isUUID:{args:4,msg:"listingId: Listing ID must be a valid UUID"}}},tokenId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"tokenId: Token ID must be a valid UUID"}}},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}}},amount:{type:sequelize_1.DataTypes.DECIMAL(36,18),allowNull:!1,validate:{min:{args:[0],msg:"amount: Amount must be positive"}}},currency:{type:sequelize_1.DataTypes.STRING(10),allowNull:!1,defaultValue:"ETH",validate:{notEmpty:{msg:"currency: Currency must not be empty"}}},transactionHash:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0},expiresAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","ACCEPTED","REJECTED","EXPIRED","CANCELLED","OUTBID"),allowNull:!1,defaultValue:"ACTIVE",validate:{isIn:{args:[["ACTIVE","ACCEPTED","REJECTED","EXPIRED","CANCELLED","OUTBID"]],msg:"status: Status must be one of 'ACTIVE', 'ACCEPTED', 'REJECTED', 'EXPIRED', 'CANCELLED', or 'OUTBID'"}}},acceptedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},rejectedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},outbidAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},cancelledAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},metadata:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("metadata");return e?JSON.parse(e):null},set(e){this.setDataValue("metadata",JSON.stringify(e))}}},{sequelize:e,modelName:"nftBid",tableName:"nft_bid",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"nftBidListingIdx",using:"BTREE",fields:[{name:"listingId"}]},{name:"nftBidUserIdx",using:"BTREE",fields:[{name:"userId"}]},{name:"nftBidTokenIdx",using:"BTREE",fields:[{name:"tokenId"}]},{name:"nftBidStatusIdx",using:"BTREE",fields:[{name:"status"}]},{name:"nftBidAmountIdx",using:"BTREE",fields:[{name:"amount"}]},{name:"nftBidExpiresAtIdx",using:"BTREE",fields:[{name:"expiresAt"}]}]})}static associate(e){nftBid.belongsTo(e.nftListing,{as:"listing",foreignKey:"listingId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftBid.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftBid.belongsTo(e.nftToken,{as:"token",foreignKey:"tokenId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=nftBid;