"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class icoTokenVestingRelease extends sequelize_1.Model{static initModel(e){return icoTokenVestingRelease.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0},vestingId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,references:{model:"ico_token_vesting",key:"id"},onDelete:"CASCADE",comment:"Reference to the parent vesting record"},releaseDate:{type:sequelize_1.DataTypes.DATE,allowNull:!1,comment:"Date when tokens should be released"},releaseAmount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{min:0},comment:"Amount of tokens to release"},percentage:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{min:0,max:100},comment:"Percentage of total vesting amount"},status:{type:sequelize_1.DataTypes.ENUM("PENDING","RELEASED","FAILED","CANCELLED"),allowNull:!1,defaultValue:"PENDING",comment:"Current status of this release"},transactionHash:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0,comment:"Blockchain transaction hash if released on-chain"},releasedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0,comment:"Actual date when tokens were released"},failureReason:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,comment:"Reason for failure if status is FAILED"},metadata:{type:sequelize_1.DataTypes.JSON,allowNull:!0,comment:"Additional metadata about the release"}},{sequelize:e,modelName:"icoTokenVestingRelease",tableName:"ico_token_vesting_release",timestamps:!0,paranoid:!0,indexes:[{fields:["vestingId"]},{fields:["releaseDate"]},{fields:["status"]},{fields:["vestingId","status"]},{fields:["releaseDate","status"]}]})}static associate(e){icoTokenVestingRelease.belongsTo(e.icoTokenVesting,{as:"vesting",foreignKey:"vestingId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=icoTokenVestingRelease;