"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class gatewayMerchantBalance extends sequelize_1.Model{static initModel(e){return gatewayMerchantBalance.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},merchantId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"merchantId: Must be a valid UUID"}}},currency:{type:sequelize_1.DataTypes.STRING(20),allowNull:!1},walletType:{type:sequelize_1.DataTypes.ENUM("FIAT","SPOT","ECO"),allowNull:!1,defaultValue:"FIAT"},available:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("available");return e?parseFloat(e.toString()):0}},pending:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("pending");return e?parseFloat(e.toString()):0}},reserved:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("reserved");return e?parseFloat(e.toString()):0}},totalReceived:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("totalReceived");return e?parseFloat(e.toString()):0}},totalRefunded:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("totalRefunded");return e?parseFloat(e.toString()):0}},totalFees:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("totalFees");return e?parseFloat(e.toString()):0}},totalPaidOut:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("totalPaidOut");return e?parseFloat(e.toString()):0}}},{sequelize:e,modelName:"gatewayMerchantBalance",tableName:"gateway_merchant_balance",timestamps:!0,createdAt:!1,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"gatewayMerchantBalanceUnique",unique:!0,using:"BTREE",fields:[{name:"merchantId"},{name:"currency"},{name:"walletType"}]},{name:"gatewayMerchantBalanceMerchantIdFkey",using:"BTREE",fields:[{name:"merchantId"}]}]})}static associate(e){gatewayMerchantBalance.belongsTo(e.gatewayMerchant,{as:"merchant",foreignKey:"merchantId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=gatewayMerchantBalance;