"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class gatewayApiKey extends sequelize_1.Model{static initModel(e){return gatewayApiKey.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},merchantId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"merchantId: Must be a valid UUID"}}},name:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"name: Key name must not be empty"}}},keyPrefix:{type:sequelize_1.DataTypes.STRING(20),allowNull:!1,validate:{isIn:{args:[["pk_live_","pk_test_","sk_live_","sk_test_"]],msg:"keyPrefix: Must be a valid key prefix"}}},keyHash:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1},lastFourChars:{type:sequelize_1.DataTypes.STRING(4),allowNull:!1},type:{type:sequelize_1.DataTypes.ENUM("PUBLIC","SECRET"),allowNull:!1},mode:{type:sequelize_1.DataTypes.ENUM("LIVE","TEST"),allowNull:!1},permissions:{type:sequelize_1.DataTypes.JSON,allowNull:!1,defaultValue:[],get(){const e=this.getDataValue("permissions");return"string"==typeof e?JSON.parse(e):e}},ipWhitelist:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("ipWhitelist");return"string"==typeof e?JSON.parse(e):e}},allowedWalletTypes:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("allowedWalletTypes");return"string"==typeof e?JSON.parse(e):e}},successUrl:{type:sequelize_1.DataTypes.STRING(500),allowNull:!0},cancelUrl:{type:sequelize_1.DataTypes.STRING(500),allowNull:!0},webhookUrl:{type:sequelize_1.DataTypes.STRING(500),allowNull:!0},lastUsedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},lastUsedIp:{type:sequelize_1.DataTypes.STRING(45),allowNull:!0},status:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0},expiresAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0}},{sequelize:e,modelName:"gatewayApiKey",tableName:"gateway_api_key",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"gatewayApiKeyMerchantIdFkey",using:"BTREE",fields:[{name:"merchantId"}]},{name:"gatewayApiKeyHashIdx",using:"BTREE",fields:[{name:"keyHash"}]},{name:"gatewayApiKeyStatusIdx",using:"BTREE",fields:[{name:"status"}]}]})}static associate(e){gatewayApiKey.belongsTo(e.gatewayMerchant,{as:"merchant",foreignKey:"merchantId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=gatewayApiKey;