"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class forexPlan extends sequelize_1.Model{static initModel(e){return forexPlan.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},name:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,unique:"forexPlanNameKey",validate:{notEmpty:{msg:"name: Name cannot be empty"}}},title:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},description:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},image:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},currency:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"currency: Currency cannot be empty"}}},walletType:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"walletType: Wallet type cannot be empty"}}},minProfit:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"minProfit: Minimum profit must be a number"}}},maxProfit:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"maxProfit: Maximum profit must be a number"}}},minAmount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!0,defaultValue:0,validate:{isFloat:{msg:"minAmount: Minimum amount must be a number"}}},maxAmount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!0,validate:{isFloat:{msg:"maxAmount: Maximum amount must be a number"}}},profitPercentage:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"profitPercentage: Profit percentage must be a number"}}},status:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!0,defaultValue:!1,validate:{isBoolean:{msg:"status: Status must be a boolean value"}}},defaultProfit:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0,validate:{isInt:{msg:"defaultProfit: Default profit must be an integer"}}},defaultResult:{type:sequelize_1.DataTypes.ENUM("WIN","LOSS","DRAW"),allowNull:!1,validate:{isIn:{args:[["WIN","LOSS","DRAW"]],msg:"defaultResult: Must be one of 'WIN', 'LOSS', 'DRAW'"}}},trending:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!0,defaultValue:!1,validate:{isBoolean:{msg:"trending: Trending must be a boolean value"}}}},{sequelize:e,modelName:"forexPlan",tableName:"forex_plan",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"forexPlanNameKey",unique:!0,using:"BTREE",fields:[{name:"name"}]},{name:"forexPlanStatusIdx",using:"BTREE",fields:[{name:"status"}]},{name:"forexPlanCurrencyIdx",using:"BTREE",fields:[{name:"currency"}]},{name:"forexPlanTrendingIdx",using:"BTREE",fields:[{name:"trending"}]}]})}static associate(e){forexPlan.hasMany(e.forexInvestment,{as:"investments",foreignKey:"planId",onDelete:"CASCADE",onUpdate:"CASCADE"});forexPlan.hasMany(e.forexPlanDuration,{as:"planDurations",foreignKey:"planId",onDelete:"CASCADE",onUpdate:"CASCADE"});forexPlan.belongsToMany(e.forexDuration,{through:e.forexPlanDuration,as:"durations",foreignKey:"planId",otherKey:"durationId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=forexPlan;