"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class aiMarketMakerPool extends sequelize_1.Model{static initModel(e){return aiMarketMakerPool.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},marketMakerId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,unique:!0,validate:{notEmpty:{msg:"marketMakerId: Market Maker ID must not be empty"},isUUID:{args:4,msg:"marketMakerId: Must be a valid UUID"}}},baseCurrencyBalance:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"baseCurrencyBalance: Must be a valid decimal number"},min:{args:[0],msg:"baseCurrencyBalance: Must be greater than or equal to 0"}},get(){const e=this.getDataValue("baseCurrencyBalance");return e?parseFloat(e.toString()):0}},quoteCurrencyBalance:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"quoteCurrencyBalance: Must be a valid decimal number"},min:{args:[0],msg:"quoteCurrencyBalance: Must be greater than or equal to 0"}},get(){const e=this.getDataValue("quoteCurrencyBalance");return e?parseFloat(e.toString()):0}},initialBaseBalance:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"initialBaseBalance: Must be a valid decimal number"},min:{args:[0],msg:"initialBaseBalance: Must be greater than or equal to 0"}},get(){const e=this.getDataValue("initialBaseBalance");return e?parseFloat(e.toString()):0}},initialQuoteBalance:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"initialQuoteBalance: Must be a valid decimal number"},min:{args:[0],msg:"initialQuoteBalance: Must be greater than or equal to 0"}},get(){const e=this.getDataValue("initialQuoteBalance");return e?parseFloat(e.toString()):0}},totalValueLocked:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"totalValueLocked: Must be a valid decimal number"},min:{args:[0],msg:"totalValueLocked: Must be greater than or equal to 0"}},get(){const e=this.getDataValue("totalValueLocked");return e?parseFloat(e.toString()):0}},unrealizedPnL:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"unrealizedPnL: Must be a valid decimal number"}},get(){const e=this.getDataValue("unrealizedPnL");return e?parseFloat(e.toString()):0}},realizedPnL:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"realizedPnL: Must be a valid decimal number"}},get(){const e=this.getDataValue("realizedPnL");return e?parseFloat(e.toString()):0}},lastRebalanceAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0}},{sequelize:e,modelName:"aiMarketMakerPool",tableName:"ai_market_maker_pool",timestamps:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"aiMarketMakerPoolMarketMakerIdKey",unique:!0,using:"BTREE",fields:[{name:"marketMakerId"}]},{name:"aiMarketMakerPoolRebalanceIdx",using:"BTREE",fields:[{name:"lastRebalanceAt"}]}]})}static associate(e){aiMarketMakerPool.belongsTo(e.aiMarketMaker,{as:"marketMaker",foreignKey:"marketMakerId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=aiMarketMakerPool;