"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class aiMarketMakerHistory extends sequelize_1.Model{static initModel(e){return aiMarketMakerHistory.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},marketMakerId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notEmpty:{msg:"marketMakerId: Market Maker ID must not be empty"},isUUID:{args:4,msg:"marketMakerId: Must be a valid UUID"}}},action:{type:sequelize_1.DataTypes.ENUM("TRADE","PAUSE","RESUME","REBALANCE","TARGET_CHANGE","DEPOSIT","WITHDRAW","START","STOP","CONFIG_CHANGE","EMERGENCY_STOP","AUTO_PAUSE","PHASE_CHANGE","BIAS_CHANGE","MOMENTUM_EVENT"),allowNull:!1,validate:{isIn:{args:[["TRADE","PAUSE","RESUME","REBALANCE","TARGET_CHANGE","DEPOSIT","WITHDRAW","START","STOP","CONFIG_CHANGE","EMERGENCY_STOP","AUTO_PAUSE","PHASE_CHANGE","BIAS_CHANGE","MOMENTUM_EVENT"]],msg:"action: Must be a valid action type"}}},details:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("details");if(!e)return null;if("string"==typeof e)try{return JSON.parse(e)}catch(e){return null}return e}},priceAtAction:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"priceAtAction: Must be a valid decimal number"}},get(){const e=this.getDataValue("priceAtAction");return e?parseFloat(e.toString()):0}},poolValueAtAction:{type:sequelize_1.DataTypes.DECIMAL(30,18),allowNull:!1,defaultValue:0,validate:{isDecimal:{msg:"poolValueAtAction: Must be a valid decimal number"}},get(){const e=this.getDataValue("poolValueAtAction");return e?parseFloat(e.toString()):0}}},{sequelize:e,modelName:"aiMarketMakerHistory",tableName:"ai_market_maker_history",timestamps:!0,updatedAt:!1,hooks:{beforeUpdate:()=>{throw new Error("History records cannot be updated - they are immutable for audit trail integrity")},beforeDestroy:(e,a)=>{if(!(null==a?void 0:a.transaction)&&!(null==a?void 0:a.cascadeDelete))throw new Error("History records cannot be directly deleted - they are immutable for audit trail integrity")}},indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"aiMarketMakerHistoryMarketMakerIdIdx",using:"BTREE",fields:[{name:"marketMakerId"}]},{name:"aiMarketMakerHistoryActionIdx",using:"BTREE",fields:[{name:"action"}]},{name:"aiMarketMakerHistoryCreatedAtIdx",using:"BTREE",fields:[{name:"createdAt"}]},{name:"aiMarketMakerHistoryMarketCreatedIdx",using:"BTREE",fields:[{name:"marketMakerId"},{name:"createdAt"}]}]})}static associate(e){aiMarketMakerHistory.belongsTo(e.aiMarketMaker,{as:"marketMaker",foreignKey:"marketMakerId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=aiMarketMakerHistory;