"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class mlmBinaryNode extends sequelize_1.Model{static initModel(e){return mlmBinaryNode.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},referralId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"referralId: Referral ID must be a valid UUID"}}},parentId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"parentId: Parent ID must be a valid UUID when provided"}}},leftChildId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"leftChildId: Left Child ID must be a valid UUID when provided"}}},rightChildId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"rightChildId: Right Child ID must be a valid UUID when provided"}}}},{sequelize:e,modelName:"mlmBinaryNode",tableName:"mlm_binary_node",timestamps:!1,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"mlmBinaryNodeReferralIdKey",unique:!0,using:"BTREE",fields:[{name:"referralId"}]},{name:"mlmBinaryNodeParentIdFkey",using:"BTREE",fields:[{name:"parentId"}]},{name:"mlmBinaryNodeLeftChildIdFkey",using:"BTREE",fields:[{name:"leftChildId"}]},{name:"mlmBinaryNodeRightChildIdFkey",using:"BTREE",fields:[{name:"rightChildId"}]}]})}static associate(e){mlmBinaryNode.belongsTo(e.mlmBinaryNode,{as:"parent",foreignKey:"parentId",onDelete:"CASCADE",onUpdate:"CASCADE"});mlmBinaryNode.hasMany(e.mlmBinaryNode,{as:"nodes",foreignKey:"parentId",onDelete:"CASCADE",onUpdate:"CASCADE"});mlmBinaryNode.belongsTo(e.mlmBinaryNode,{as:"leftChild",foreignKey:"leftChildId",onDelete:"CASCADE",onUpdate:"CASCADE"});mlmBinaryNode.hasMany(e.mlmBinaryNode,{as:"leftChildBinaryNodes",foreignKey:"leftChildId",onDelete:"CASCADE",onUpdate:"CASCADE"});mlmBinaryNode.belongsTo(e.mlmBinaryNode,{as:"rightChild",foreignKey:"rightChildId",onDelete:"CASCADE",onUpdate:"CASCADE"});mlmBinaryNode.hasMany(e.mlmBinaryNode,{as:"rightChildBinaryNodes",foreignKey:"rightChildId",onDelete:"CASCADE",onUpdate:"CASCADE"});mlmBinaryNode.belongsTo(e.mlmReferral,{as:"referral",foreignKey:"referralId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=mlmBinaryNode;